<?php
/**
 * Class mweb_theme_thumbnail
 * this file handle thumbnail for theme
 */
if ( ! class_exists( 'mweb_theme_thumbnail' ) ) {
	class mweb_theme_thumbnail {

		static function render( $size , $link_to_attachment = false , $container = false , $class = '' ) {  

			$mweb_post_id = get_the_ID();

			//create class
			$mweb_class   = array();
			$mweb_class[] = $class;
			//$mweb_class[] = 'post-thumb';
			$mweb_class[] = 'is-image';
			
			$mweb_class = implode( ' ', $mweb_class );

			//render
			$str = '';
			
			if( $container === true )
			$str .= '<div class="' . $mweb_class . '">';

			if ( has_post_thumbnail() ) {
				$featured_title      = get_the_title( get_post_thumbnail_id( $mweb_post_id ) );
				$featured_attachment = wp_get_attachment_image_src( get_post_thumbnail_id( $mweb_post_id ), $size );

				if ( ! empty( $featured_attachment[0] ) ) {
					$width  = 0;
					$height = 0;

					//check
					if ( ! empty( $featured_attachment[1] ) ) {
						$width = 'width="' . $featured_attachment[1] . '"';
					}
					if ( ! empty( $featured_attachment[2] ) ) {
						$height = 'height="' . $featured_attachment[2] . '"';
					}
					//render
					if ( false === $link_to_attachment ) {
						$str .= '<a href="' . get_permalink() . '" title="' . esc_attr( strip_tags( get_the_title() ) ) . '" rel="bookmark">';
						$str .= '<img ' . $width . ' ' . $height . ' src="' . $featured_attachment[0] . '"  alt="' . $featured_title . '"/>';
						$str .= '</a>';
					} else {
						//$mweb_full_image_attachment = wp_get_attachment_image_src( get_post_thumbnail_id( $mweb_post_id ), 'full' );
						//$str .= '<a href="' . $mweb_full_image_attachment[0] . '" title="' . esc_attr( strip_tags( get_the_title() ) ) . '" rel="bookmark">';
						$str .= '<img ' . $width . ' ' . $height . ' src="' . $featured_attachment[0] . '"  alt="' . $featured_title . '"/>';
						//$str .= '</a>';
					}

				} else {
					$str .= self::render_block_no_thumb( $size );
				}
			} else {
				$str .= self::render_block_no_thumb( $size );
			}

			if( $container === true )
			$str .= '</div>';

			return $str;
		}
		
		
		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param      $size
		 *
		 * @return array
		 * render first icon
		 */
		static function get_icon( $size , $link = true ) {  

			$mweb_post_id = get_the_ID();

			$product_icon = get_post_meta( $mweb_post_id, '_product_icon', true );
			//render
			$str = '';


			if ( !empty($product_icon) ) {
				$featured_title      = get_the_title( get_post_thumbnail_id( $mweb_post_id ) );
				$featured_attachment = wp_get_attachment_image_src( $product_icon, $size );

				if ( ! empty( $featured_attachment[0] ) ) {
					$width  = 0;
					$height = 0;

					//check
					if ( ! empty( $featured_attachment[1] ) ) {
						$width = 'width="' . $featured_attachment[1] . '"';
					}
					if ( ! empty( $featured_attachment[2] ) ) {
						$height = 'height="' . $featured_attachment[2] . '"';
					}
					
					//render
					if($link === true){
						$str .= '<a href="' . get_permalink() . '" title="' . esc_attr( strip_tags( get_the_title() ) ) . '" rel="bookmark">';
						$str .= '<img ' . $width . ' ' . $height . ' src="' . $featured_attachment[0] . '"  alt="' . $featured_title . '"/>';
						$str .= '</a>';
					}else{
						$str .= '<img class="ph_thumb" ' . $width . ' ' . $height . ' src="' . $featured_attachment[0] . '"  alt="' . $featured_title . '"/>';
					}
				
				

				} else {
					$str .= self::render_block_no_thumb( $size );
				}
			} else {
				$str .= self::render_block_no_thumb( $size );
			}



			return $str;
		}
		
		
		
		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param      $size
		 *
		 * @return array
		 * render thumbnail detail
		 */
		static function get_detail( $size ) {  

			$mweb_post_id = get_the_ID();

			if ( has_post_thumbnail() ) {
				$featured_title      = get_the_title( get_post_thumbnail_id( $mweb_post_id ) );
				$featured_attachment = wp_get_attachment_image_src( get_post_thumbnail_id( $mweb_post_id ), $size );

				if ( ! empty( $featured_attachment[0] ) ) {
					
					$width  = 0;
					$height = 0;

					//check
					if ( ! empty( $featured_attachment[1] ) ) {
						$width = $featured_attachment[1];
					}
					if ( ! empty( $featured_attachment[2] ) ) {
						$height = $featured_attachment[2];
					}
					
					return array('src' => $featured_attachment[0] , 'alt' => $featured_title , 'width' => $width , 'height' => $height );

				} else {
					$url = get_template_directory_uri() . '/assets/images/no-thumb-' . $size . '.png';
					return array('src' => $url , 'alt' => 'فاقد تصویر'  );
				}
			} else {
				$url = get_template_directory_uri() . '/assets/images/no-thumb-' . $size . '.png';
				return array('src' => $url , 'alt' => 'فاقد تصویر'  );
			}


		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param      $size
		 *
		 * @return string
		 * render no thumb
		 */
		static function render_block_no_thumb( $size ) {

			//check attachment page
			if ( is_attachment() ) {
				return false;
			}

			$str = '';
			$str .= '<div class="post-no-thumb">';
			$str .= self::render_no_thumb_image( $size );
			$str .= '</div>';

			return $str;
		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param $size
		 *
		 * @return string
		 * render no thumb image
		 */
		static function render_no_thumb_image( $size ) {
			$str = '<a href="' . get_permalink() . '" title="' . esc_attr( strip_tags( get_the_title() ) ) . '" rel="bookmark">';
			$url = get_template_directory_uri() . '/assets/images/no-thumb-' . $size . '.png';
			$str .= '<img src="' . $url . '" alt="فاقد تصویر شاخص"/>';
			$str .= '</a>';

			return $str;
		}


	



	}
}