<?php
/**
 * Class mweb_theme_template_parts
 * This file render some part template for theme
 */

global $modules_data;

if ( ! class_exists( 'mweb_theme_template_part' ) ) {
	class mweb_theme_template_part {
		

		
		/**-------------------------------------------------------------------------------------------------------------------------
		 * render post title
		 */
		static function post_title($link='true') {
		    if($link){
				//render
				
				echo '<a href="' . get_permalink() . '" rel="bookmark" title="' . esc_attr( strip_tags( get_the_title() ) ) . '">';
				the_title();
				echo '</a>';
				
			}
			else {
			the_title();
			}
		}
		
		
		/**-------------------------------------------------------------------------------------------------------------------------
		 * render post permalink 
		 */
		static function post_permalink($var_echo='true') {
		    if($var_echo){
				//render
				the_permalink(); 
			}
			else {
				return get_permalink();
			}
		}
		
		
		/**-------------------------------------------------------------------------------------------------------------------------
		 * render post first cat
		 */
		static function post_first_cat($name=true) {
		    $category = get_the_category();
			$first_cat = '';
			if ($category) {
			   if($name === true) {
			   $first_cat = $category[0]->cat_name;
			   } else {
			   $first_cat = get_category_link($category[0]->term_id);
		       }
		    }
		
			echo $first_cat;
			
		}
		
		
		
		/**-------------------------------------------------------------------------------------------------------------------------
		 * render post format icon
		 */
		static function post_format_icon() {
		    $format = get_post_format();
			switch ($format) {
				case "gallery":
					$format = 'fa-camera-retro';
					break;
				case "link":
					$format = 'fa-link';
					break;
				case "image":
				   $format = 'fa-camera-retro';
					break;
				case "quote":
					$format = 'fa-quote-left';
					break;
				case "video":
					$format = 'fa-play-circle';
					break;
				case "audio":
					$format = 'fa-music';
					break;
				default:
					$format = 'fa-file-alt';
			}
			echo '<i class="fal '.$format.'"></i>';
			
		}
		



		/*-----------------------------------------------------------------------------------*/
		/* display the social network
		/*-----------------------------------------------------------------------------------*/

		static function mweb_social_icons($classes=''){

				$socials = mweb_theme_util::get_theme_option('mweb_social_icons');
				

				if ( is_array($socials) && !empty($socials)){
					$str = '<div class="contact_social_wrap '.$classes.'">'; 
					foreach ($socials as $social => $sol ) {
						if($social == 'aparat' && !empty($sol)){
							$str .= '<a href="'.esc_url($sol).'" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 68.33 68.33"><g id="Layer_2" data-name="Layer 2"><g id="brand"><g id="icon--white"><path class="cls-1" d="M29.49,2,23.2.36A10.58,10.58,0,0,0,10.25,7.87L8.68,13.8A32.4,32.4,0,0,1,29.49,2Z"/><path class="cls-1" d="M1.9,39.33.36,45.14A10.58,10.58,0,0,0,7.87,58.08l6,1.6A32.41,32.41,0,0,1,1.9,39.33Z"/><path class="cls-1" d="M60.46,10.25,53.73,8.46a32.4,32.4,0,0,1,12.4,21.7l1.85-7A10.58,10.58,0,0,0,60.46,10.25Z"/><path class="cls-1" d="M38.69,66.26,45.14,68a10.58,10.58,0,0,0,12.94-7.51l1.82-6.84A32.42,32.42,0,0,1,38.69,66.26Z"/><path class="cls-1" d="M34.17,4.54A29.63,29.63,0,1,0,63.79,34.17,29.63,29.63,0,0,0,34.17,4.54ZM17.39,19.32a8.46,8.46,0,1,1,6.71,9.91A8.46,8.46,0,0,1,17.39,19.32ZM29.7,44.92A8.46,8.46,0,1,1,23,35,8.46,8.46,0,0,1,29.7,44.92Zm3.59-6.85a3.76,3.76,0,1,1,4.41-3A3.76,3.76,0,0,1,33.29,38.07ZM50.94,49a8.46,8.46,0,1,1-6.71-9.91A8.46,8.46,0,0,1,50.94,49Zm-5.6-15.68a8.46,8.46,0,1,1,9.91-6.71A8.46,8.46,0,0,1,45.34,33.33Z"/></g></g></g></svg></a>';
							continue;
						}
						if(!empty($sol))
					$str .= '<a href="'.esc_url($sol).'" target="_blank"><i class="fab fa-'.esc_attr($social).'"></i></a>';
					}
					$str .= '</div>';
					
					return $str;
				}
					
			}



		/*-----------------------------------------------------------------------------------*/
		/* get product share
		/*-----------------------------------------------------------------------------------*/
		static function get_product_share() {
			
			$shortlink = get_permalink();
			$title = get_the_title(get_the_ID());
			$image = '';
			if (has_post_thumbnail()) {
				$image_id = get_post_thumbnail_id();
				$image_url = wp_get_attachment_image_src($image_id, 'full');
				$image = $image_url[0];
			} 
			
			//get the sharing media
			$websites = mweb_theme_util::get_theme_option('sharing_social_product',array());
			$links = array();
			if(!empty($websites)){
				foreach ($websites as $site) :
					
					$media = isset($site) ? $site : '';

					switch ($media) {
						case 'facebook':
							$pre_link = 'https://www.facebook.com/sharer/sharer.php?u='.$shortlink.'&t='.$title;
							break;
						case 'twitter':
							$pre_link = 'https://twitter.com/share?url='.$shortlink;
							break;
						case 'google-plus':
							$pre_link = 'https://plus.google.com/share?url='.$shortlink;
							break;
						case 'digg':
							$pre_link = 'http://digg.com/submit?url='.$shortlink;
							break;
						case 'pinterest':
							$pre_link = 'https://pinterest.com/pin/create/bookmarklet/?media='.$image.'&url='.$shortlink;
							break;
						case 'linkedin':
							$pre_link = 'http://www.linkedin.com/shareArticle?url='.$shortlink.'&title='.$title;
							break;
						case 'buffer':
							$pre_link = 'http://bufferapp.com/add?text='.$title.'&url='.$shortlink;
							break;
						case 'tumblr':
							$pre_link = 'http://www.tumblr.com/share/link?url='.$shortlink.'&name='.$title;
							break;
						case 'reddit':
							$pre_link = 'http://reddit.com/submit?url='.$shortlink.'&title='.$title;
							break;
						case 'stumbleUpon':
							$pre_link = 'http://www.stumbleupon.com/submit?url='.$shortlink.'&title='.$title;
							break;
						case 'whatsapp':
							$pre_link = 'whatsapp://send?text='.$title.urlencode($shortlink);
							break;
						case 'telegram':
							$pre_link = 'https://telegram.me/share/url?url='.$shortlink.'&title='.$title;
							break;
						default:
							$pre_link = '';
							break;
					}
					
					if ($pre_link != '')
						$this_link = '<a class="fab fa-'.$media.'" href="'.$pre_link.'" target="_blank"></a>';
					
					$links[] = $this_link; 
				endforeach; 
					
			}
				
				
			global $current_user;

			$str = '<div class="product_shortlink"><input onClick="this.select();" value="'.wp_get_shortlink().'" /><i class="fal fa-copy"></i></div>';
			$str .= '<div class="product_share coloring">';
				if ( !empty ($links) ){
					$str .= implode( '', $links);
				}
			$str .='</div>';
					
			echo $str;
			
		}
		
		
		

		/*-----------------------------------------------------------------------------------*/
		/* display search form
		/*-----------------------------------------------------------------------------------*/
		static function mweb_searchform($classes=''){
			echo '<form class="search_form '.$classes.'" method="get" action="'.esc_url( home_url( '/' ) ).'">
			<button></button>
			<input type="text" name="s" value="';
			if (is_search()) { echo get_search_query(); };
			echo '" placeholder="کلید واژه مورد نظر ..">
			</form>';
		}




		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param      $excerpt_length
		 * @param bool $display_short_code
		 * excerpt
		 */
		static function excerpt( $excerpt_length, $display_short_code = false ) {

			//check
			if ( empty( $excerpt_length ) ) {
				return false;
			}

			//render
			global $post;

			if ( ! empty( $post->post_excerpt ) ) {
				echo '<div class="desc">' . $post->post_excerpt. '</div>';
			} else {
				$post_content = $post->post_content;
				if ( ! $display_short_code ) {
					$post_content = preg_replace( '`\[[^\]]*\]`', '', $post->post_content );
				}
				$post_content = stripslashes( wp_filter_nohtml_kses( $post_content ) );

				echo '<div class="desc">' . wp_trim_words( $post_content, $excerpt_length, ' ...' ) . '</div>';
			}
		}


	

		/**-------------------------------------------------------------------------------------------------------------------------
		 * render page pagination as html
		 */
		static function pagination() {

			$mweb_pagination_style = mweb_theme_util::get_theme_option( 'page_pagination_style' );

			//check search page
			if ( is_search() || ( is_archive() && ! is_category() ) ) {
				$mweb_pagination_style = 'standard';
			}

			switch ( $mweb_pagination_style ) {
				case 'load_more' :
					self::pagination_load_more();
					break;
				default :
					self::pagination_standard();
					break;
			}
		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param null $custom_query
		 * @param bool $echo
		 *
		 * @return string
		 * render pagination standard
		 */
		static function pagination_standard( $custom_query = null, $echo = true ) {
			global $wp_query, $wp_rewrite;

			if ( ! empty( $custom_query ) ) {
				$mweb_query = $custom_query;
			} else {
				$mweb_query = $wp_query;
			}

			if ( is_single() || ( $mweb_query->max_num_pages < 2 ) ) {
				return false;
			}

			$mweb_enable_simple_pagination = mweb_theme_util::get_theme_option( 'simple_page_pagination' );


			//render pagination
			$str = '';

			$str .= '<div class="pagination-wrap clear">';

			if ( empty( $mweb_enable_simple_pagination ) ) {
				$str .= '<div class="pagination-num">';
				$mweb_query->query_vars['paged'] > 1 ? $current = $mweb_query->query_vars['paged'] : $current = 1;
				$pagination = array(
					'base'      => @add_query_arg( 'paged', '%#%' ),
					'format'    => '',
					'total'     => $mweb_query->max_num_pages,
					'current'   => $current,
					'prev_text' => '<i class="fal fa-long-arrow-left"></i>',
					'next_text' => '<i class="fal fa-long-arrow-right"></i>',
					'type'      => 'plain'
				);
				if ( $wp_rewrite->using_permalinks() ) {
					$pagination['base'] = user_trailingslashit( trailingslashit( remove_query_arg( 's', get_pagenum_link( 1 ) ) ) . 'page/%#%/', 'paged' );
				}
				if ( ! empty( $mweb_query->query_vars['s'] ) ) {
					$pagination['add_args'] = array( 's' => urlencode( get_query_var( 's' ) ) );
				}
				$str .= paginate_links( $pagination );
				$str .= '</div>';

			} else {
				$str .= '<div class="older">' . get_next_posts_link( esc_attr__( 'مطالب قدیمی', 'mweb' ) . '<i class="fal fa-long-arrow-right"></i>', $mweb_query->max_num_pages ) . '</div>';
				$str .= '<div class="newer">' . get_previous_posts_link( '<i class="fal fa-long-arrow-left"></i>' . esc_attr__( 'مطالب جدید', 'mweb' ), $mweb_query->max_num_pages ) . '</div>';

			}
			$str .= '</div>';

			if ( true === $echo ) {
				echo( $str );
			} else {
				return $str;
			}
		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * render pagination load more
		 */
		static function pagination_load_more($id, $pagination = "next_prev" ) {
			$str = '';
			switch ( $pagination ) {
				case "next_prev" :
					$str .= '<div class="next-prev-wrap">';
					$str .= '<a href="#" class="mweb-ajax-prev ajax-disable" id="prev_' . $id . '">قبل</a>';
					$str .= '<a href="#" class="mweb-ajax-next" id="next_' . $id . '">بعد</a>';
					$str .= '</div>';
					break;
				case 'loadmore':
					$str .= '<div class="loadmore-wrap">';
					$str .= '<a href="#" class="mweb-ajax-loadmore" id="loadmore_' . $id . '">بارگذاری بیشتر ...</a>';
					$str .= '<div class="loadmore-img-wrap">';
					$str .= '<div class="loadmore-img"></div>';
					$str .= '</div>';
					$str .= '</div>';
					break;
			}

			return $str;
		}


		


		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param string $classes
		 * @param string $sidebar_position
		 * @param bool $disable_wrapper
		 * open page wrap
		 */
		static function open_page_wrap( $classes = '', $sidebar_position = '', $disable_row = false, $disable_wrapper = false  ) {

			//create wrap class
			$mweb_classes   = array();
			$mweb_classes[] = 'page-wrap';
			$mweb_classes[] = esc_attr( $classes );
			if($sidebar_position ){
			$mweb_classes[] = 'is-sidebar-' . esc_attr( $sidebar_position );
			}
			if ( false === $disable_wrapper ) {
				$mweb_classes[] = 'container';
			}
			
			$mweb_classes = implode( ' ', $mweb_classes );

			//render
			echo '<div class="' . esc_attr( $mweb_classes ) . '">';
			if($disable_row === false){
				echo '<div class="row">';
			}

		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param string $classes
		 * @param string $sidebar_position
		 * @param string $blog_layout
		 * @param bool $big_first
		 * open page inner
		 */
		static function open_page_inner( $classes = '', $sidebar_position = '', $blog_layout = '') {

			//create wrap class
			$mweb_classes   = array();
			$mweb_classes[] = 'content-wrap';
			$mweb_classes[] = esc_attr( $classes );
				
				// is_single()  && !has_post_format( 'gallery' ) && !has_post_format( 'video' )
				if ( 'none' == $sidebar_position ) {
					$mweb_classes[] = 'content-without-sidebar col-12';
				} else {
					$mweb_classes[] = 'col-md-9 col-sm-12 content-with-sidebar';
				}
									

			
			$mweb_classes = implode( ' ', $mweb_classes );

			//render
			echo '<div class="' . esc_attr( $mweb_classes ) . '">';
			
		}

		/**-------------------------------------------------------------------------------------------------------------------------
		 * @return string
		 * open content inner
		 */
		static function open_ajax_wrap() {
			return '<div class="ajax-wrap">';
		}

		/**-------------------------------------------------------------------------------------------------------------------------
		 * @return string
		 * open content inner
		 */
		static function open_content_inner($disable_row = true) {
			echo '<div class="content-inner">';
			if($disable_row === false){
				echo '<div class="row">';
			}
		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * close page inner
		 */
		static function close_page_inner() {
			echo '</div>';
		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * close page wrap
		 */
		static function close_page_wrap( $disable_row = false) {
			if($disable_row === false){
				echo '</div>';
			}
			echo '</div>';
		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * close content inner
		 */
		static function close_content_inner($disable_row = true) {
			if($disable_row === false){
				echo '</div>';
			}
			echo '</div>';
		}

		/**-------------------------------------------------------------------------------------------------------------------------
		 * close page inner
		 */
		static function close_ajax_wrap() {
			return '</div>';
		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param      $name
		 * @param bool $disable_makeup
		 * render sidebar
		 */
		static function sidebar( $name, $disable_makeup = false ) {

			//sticky config
			$sticky = mweb_theme_util::get_theme_option( 'sticky_sidebar' );

			//makeup
			if ( false === $disable_makeup ) {
				$makeup = mweb_theme_schema::makeup( 'sidebar', false );
			} else {
				$makeup = '';
			}
			
			$mweb_class ='col-md-3 col-sm-12 col-12';
			

			if ( ! empty( $sticky ) ) {
				echo '<div id="sidebar" class="sidebar-wrap '.$mweb_class.' clearfix" ' . $makeup . '><div class="mweb-sidebar-sticky">';
				echo '<div class="sidebar-inner">';
				if ( is_active_sidebar( $name ) ) {
					dynamic_sidebar( $name );
				}
				echo '</div>';
				echo '</div></div>';
			} else {
				echo '<div id="sidebar" class="sidebar-wrap '.$mweb_class.' clearfix" ' . $makeup . '>';
				echo '<div class="sidebar-inner">';
				if ( is_active_sidebar( $name ) ) {
					dynamic_sidebar( $name );
				}
				echo '</div>';
				echo '</div>';
			}
		}
		
		
		
		
		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param string $class
		 *
		 * @return string
		 * render divider
		 */
		static function render_divider( $classes = '' ) {
			echo '<div class="' . esc_attr( $classes ) . ' is-divider"></div>';
		}
	}
}