<?php
/**
 * Class mweb_theme_template_parts
 * This file render some part template for theme
 */

if ( ! class_exists( 'mweb_theme_single_layout' ) ) {
	class mweb_theme_single_layout {

		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param string $class
		 * @param bool   $review
		 * render open single tag
		 */
		static function open_single_wrap( $class = '' ) {
			
			
			if ( ! empty( $ajax_view ) && function_exists( 'mweb_theme_post_view_add' ) ) {
				$class = $class . ' ' . 'mweb-ajax-view-add';
			}
			$str = '<article class="' . implode( ' ', get_post_class( $class ) ) . '" ' . mweb_theme_schema::makeup( 'article', false );
			if ( ! empty( $ajax_view ) && function_exists( 'mweb_theme_post_view_add' ) ) {
			$str .= ' ' . 'data-post_id ="' . get_the_ID() . '"';
			}
			$str .= '>';
			
			echo $str;
			
		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * render close single tag
		 */
		static function close_single_wrap() {
			echo '</article><!--#single post -->';
		}

	



		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param bool $disable_makeup
		 * render single sidebar
		 */
		static function single_sidebar( $disable_makeup = false ) {

			//check
			$sidebar_position = mweb_theme_single::get_sidebar_position();
			if ( 'none' == $sidebar_position ) {
				return false;
			}

			$all_sidebar = mweb_theme_config::sidebar_name( true );

			//single sidebar name
			$sidebar_name = get_post_meta( get_the_ID(), 'mweb_sidebar_title', true );
			if ( ! array_key_exists( $sidebar_name, $all_sidebar ) ) {
				$sidebar_name = 'mweb_default_from_theme_options';
			}
			if ( 'mweb_default_from_theme_options' == $sidebar_name || empty( $sidebar_name ) ) {
				$sidebar_name = mweb_theme_util::get_theme_option( 'default_single_post_sidebar' );
			}

			//render
			mweb_theme_template_part::sidebar( $sidebar_name, $disable_makeup );
		}


		/**-------------------------------------------------------------------------------------------------------------------------
		 * render single schema makeup
		 */
		static function single_schema_makeup() {
			if ( ! is_single() ) {
				return false;
			};

			$mweb_http = 'http';
			if ( is_ssl() ) {
				$mweb_http = 'https';
			}

			$mweb_publisher = get_bloginfo( 'name' );
			if ( ! empty( $mweb_publisher ) ) {
				$mweb_publisher = get_the_author_meta( 'display_name' );
			}

			//publisher logo
			$mweb_publisher_logo = mweb_theme_util::get_theme_option( 'mweb_logo' ,'url' );
			
			

			$mweb_post_date   = get_the_time( 'U' );
			$mweb_post_update = get_the_modified_time( 'U' );

			$mweb_full_image_attachment = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );

			$str = '';
			$str .= '<meta itemscope itemprop="mainEntityOfPage" itemType="' . $mweb_http . '://schema.org/WebPage" itemid="' . get_permalink() . '"/>';

			//headline
			$str .= '<meta itemprop="headline" content="' . esc_attr( strip_tags( get_the_title() ) ) . '">';

			//author
			$str .= '<span style="display: none;" itemprop="author" itemscope itemtype="' . $mweb_http . '://schema.org/Person">';
			$str .= '<meta itemprop="name" content="' . esc_attr( get_the_author_meta( 'display_name' ) ) . '">';
			$str .= '</span>';

			//image
			$str .= '<span style="display: none;" itemprop="image" itemscope itemtype="' . $mweb_http . '://schema.org/ImageObject">';
			$str .= '<meta itemprop="url" content="' . $mweb_full_image_attachment[0] . '">';
			$str .= '<meta itemprop="width" content="' . $mweb_full_image_attachment[1] . '">';
			$str .= '<meta itemprop="height" content="' . $mweb_full_image_attachment[2] . '">';
			$str .= '</span>';

			//publisher
			$str .= '<span style="display: none;" itemprop="publisher" itemscope itemtype="' . $mweb_http . '://schema.org/Organization">';
			$str .= '<span style="display: none;" itemprop="logo" itemscope itemtype="' . $mweb_http . '://schema.org/ImageObject">';
			if ( ! empty( $mweb_publisher_logo ) ) {
				$str .= '<meta itemprop="url" content="' . $mweb_publisher_logo . '">';
			}
			$str .= '</span>';
			$str .= '<meta itemprop="name" content="' . $mweb_publisher . '">';
			$str .= '</span>';

			$str .= '<meta itemprop="datePublished" content="' . date( DATE_W3C, $mweb_post_date ) . '"/>';
			$str .= '<meta itemprop="dateModified" content="' . date( DATE_W3C, $mweb_post_update ) . '"/>';

		

			echo( $str );

		}
		
		
		
		
		
		/*-----------------------------------------------------------------------------------*/
		/* display the social sharing 
		/*-----------------------------------------------------------------------------------*/

			
		static function mweb_social_sharing($classes = ''){
			
			$shortlink = wp_get_shortlink();
			$title = get_the_title(get_the_ID());
			$image = '';
			if (has_post_thumbnail()) {
				$image_id = get_post_thumbnail_id();
				$image_url = wp_get_attachment_image_src($image_id, 'full');
				$image = $image_url[0];
			} 
			
			//get the sharing media
			$websites = mweb_theme_util::get_theme_option('sharing_social_medias',array());
			$links = array();
			if(!empty($websites)){
			foreach ($websites as $site) :
				
				$media = isset($site) ? $site : '';

				switch ($media) {
					case 'facebook':
						$pre_link = 'https://www.facebook.com/sharer/sharer.php?u='.$shortlink.'&t='.$title;
						break;
					case 'twitter':
						$pre_link = 'https://twitter.com/share?url='.$shortlink;
						break;
					case 'google-plus':
						$pre_link = 'https://plus.google.com/share?url='.$shortlink;
						break;
					case 'digg':
						$pre_link = 'http://digg.com/submit?url='.$shortlink;
						break;
					case 'pinterest':
						$pre_link = 'https://pinterest.com/pin/create/bookmarklet/?media='.$image.'&url='.$shortlink;
						break;
					case 'linkedin':
						$pre_link = 'http://www.linkedin.com/shareArticle?url='.$shortlink.'&title='.$title;
						break;
					case 'buffer':
						$pre_link = 'http://bufferapp.com/add?text='.$title.'&url='.$shortlink;
						break;
					case 'tumblr':
						$pre_link = 'http://www.tumblr.com/share/link?url='.$shortlink.'&name='.$title;
						break;
					case 'reddit':
						$pre_link = 'http://reddit.com/submit?url='.$shortlink.'&title='.$title;
						break;
					case 'stumbleUpon':
						$pre_link = 'http://www.stumbleupon.com/submit?url='.$shortlink.'&title='.$title;
						break;
					case 'whatsapp':
						$pre_link = 'whatsapp://send?text='.$title;
						break;
					case 'telegram':
						$pre_link = 'https://telegram.me/share/url?url='.$shortlink.'&title='.$title;
						break;
					default:
						$pre_link = '';
						break;
				}
				
				if ($pre_link != '')
					$this_link = '<a class="fab fa-'.$media.'" href="'.$pre_link.'" target="_blank"></a>';
				
				$links[] = $this_link; 
			endforeach; 
				
			$output = '<div class="blog_share '.$classes.'">';
			if ( !empty ($links) ){
				$output .= implode( '', $links);
			}
			$output .='</div>';

			echo $output;
				
			}
			   
		}
		

		
		
	}
}