<div class="product_item clear"> 
	<div class="product_image_area">
		<a class="product_image" href="<?php the_permalink(); ?>">
		<?php
			/**
			 * woocommerce_before_shop_loop_item_title hook.
			 *
			 * @hooked woocommerce_show_product_loop_sale_flash - 10
			 * @hooked woocommerce_template_loop_product_thumbnail - 10
			 */
			do_action( 'woocommerce_before_shop_loop_item_title' );
		?>
		</a>
		<?php mweb_woocommerce::mweb_woocommerce_check_stock(); ?>

	</div>
	<div class="product_detail_area">
		<h3 class="product_name"><?php mweb_theme_template_part::post_title(); ?></h3>
		
		<div class="product_item_info">
			<a href="<?php the_permalink(); ?>" class="product_read_more"><i class="fal fa-long-arrow-alt-left"></i></a>
			<?php get_template_part( 'woocommerce/loop/price' ); ?>
		</div>
		<div class="product_item_meta">
			<?php 
				$meta_time = get_post_meta( get_the_ID(), '_product_time', true );
				$meta_rating = mweb_woocommerce::mweb_get_average_rating();
				$meta_sales = mweb_woocommerce::mweb_get_product_sales();
			?>
			<?php if( $meta_rating > 0 ): ?>
			<div class="item_meta el_avarage_rate">
				<i class="fal fa-star"></i>
				<span><?php echo round( $meta_rating , 1 ); ?></span>
			</div>
			<?php endif; ?>
			<?php if( $meta_time ): ?>
			<div class="item_meta el_product_time">
				<i class="fal fa-clock"></i>
				<span><?php echo mweb_hoursandmins($meta_time); ?></span>
			</div>
			<?php endif; ?>
			<?php if( $meta_sales ): ?>
			<div class="item_meta el_product_sales">
				<i class="fal fa-users-class"></i>
				<span><?php echo $meta_sales; ?></span>
			</div>
			<?php endif; ?>		
		</div>
		
			
			
	</div>
	<?php mweb_woocommerce::mweb_deal_countdown_timer(); ?>	
	
</div> 