<?php
namespace ElementorMahdisweb\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly



/**
 * Elementor Footer Menu
 * @since 1.0.0
 */
class My_Footer_Menu extends Widget_Base {

	
	public function get_name() {
		return 'my-footer-menu';
	}
	
	public function get_title() {
		return __( 'منو', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-divider-shape';
	}

	public function get_categories() {
		return [ 'digiacademy_footer' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'منو', 'mweb' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'description' => ''
			]
		);
		
		$this->add_control(
			'color_title',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elm_widget .widget_head' => 'color: {{VALUE}}',
				]
			]
		);
		
		$this->add_control(
			'menu_name',
			[
				'label' => __( 'انتخاب منو', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => get_element_menu_list(),
			]
		);
		
		$this->add_control(
			'color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .widget_nav_menu .widget-content ul li a' => 'color: {{VALUE}}',
				]
			]
		);
		
		$this->add_control(
			'hover_color',
			[
				'label' => __( 'رنگ متن هاور', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .widget_nav_menu .widget-content ul li:hover a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .widget_nav_menu .widget-content ul li a:hover:before' => 'color: {{VALUE}}',
				]
			]
		);

		$this->end_controls_section();

		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		$nav_menu = ! empty( $settings['menu_name'] ) ? wp_get_nav_menu_object( $settings['menu_name'] ) : false;

		if ( !$nav_menu )
			return;
		
		echo '<div class="widget widget_nav_menu elm_widget">';
			if(!empty($settings['title'])){
				echo '<div class="widget_head">'.$settings['title'].'</div>';
			}
			echo '<div class="widget-content">';
			wp_nav_menu( array(
				'menu' => $nav_menu,
				'container' => false, 
				'menu_id' => '',
				'menu_class' => ''
			));
			
		echo '</div></div>';
		
	}

	
	protected function _content_template() {
		
	}
}



/**
 * Elementor Footer Namad
 * @since 1.0.0
 */
class My_Footer_Namad extends Widget_Base {

	
	public function get_name() {
		return 'my-footer-namad';
	}
	
	public function get_title() {
		return __( 'نماد / اسلایدر', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-slides';
	}

	public function get_categories() {
		return [ 'digiacademy_footer' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'description' => ''
			]
		);
		
		$this->add_control(
			'color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elm_widget .widget_head' => 'color: {{VALUE}}',
				]
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'list_code',
			[
				'label' => __( 'کد نماد', 'mweb' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => '',
				'description' => ''
			]
		);
		
		$this->add_control(
			'list',
			[
				'label' => __( 'ایتم ها', 'mweb' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ list_code }}}',
			]
		);
		
		$this->end_controls_section();


		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		if ( $settings['list'] ) {
		echo '<div class="widget contact-namad-widget elm_widget">';
			if(!empty($settings['title'])){
				echo '<div class="widget_head">'.$settings['title'].'</div>';
			}
			echo '<div class="widget-content namad_slider_wrap">';
			echo '<div class="owl-carousel mw-owl-carousel" data-margin="0" data-nav="false" data-autoplay="true"  data-dots="true"  data-rtl="true" data-loop="true" data-responsiveClass="true" data-responsive=\'{"0":{"items":1},"600":{"items":1},"768":{"items":1},"1000":{"items":1},"1200":{"items":1}}\' >';
			foreach (  $settings['list'] as $item ) {
				echo '<div class="item">'.$item['list_code'].'</div>';
			}
			echo '</div>';
		echo '</div></div>';
		}
	}

	
	protected function _content_template() {
		
	}
}



/**
 * Elementor Footer Contact
 * @since 1.0.0
 */
class My_Footer_Contact extends Widget_Base {

	
	public function get_name() {
		return 'my-footer-contact';
	}
	
	public function get_title() {
		return __( 'ارتباط با ما', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-tel-field';
	}

	public function get_categories() {
		return [ 'digiacademy_footer' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'description' => ''
			]
		);
		
		$this->add_control(
			'phone',
			[
				'label' => __( 'تلفن', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		
		$this->add_control(
			'mail',
			[
				'label' => __( 'ایمیل', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		
		$this->add_control(
			'address',
			[
				'label' => __( 'آدرس', 'mweb' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		
		$this->add_control(
			'color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elm_widget .widget_head' => 'color: {{VALUE}}',
				]
			]
		);
		
		$this->add_control(
			'show_social',
			[
				'label' => __( 'نمایش شبکه های اجتماعی', 'mweb' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'بلی', 'mweb' ),
				'label_off' => __( 'خیر', 'mweb' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		
		
		$this->end_controls_section();

	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		echo '<div class="widget contact-us-widget elm_widget">';
			if(!empty($settings['title'])){
				echo '<div class="widget_head">'.$settings['title'].'</div>';
			}
			echo '<div class="widget-content">';
			
				if(!empty($settings['address'])){ 
					echo '<div class="contact_item address"><i class="fal fa-map-marked-alt"></i><span>'.$settings['address'].'</span></div>';
				}
				if(!empty($settings['phone'])){
					echo '<div class="contact_item phone"><i class="fal fa-phone-volume"></i><strong>'.substr($settings['phone'], 0, 4).'</strong>'.substr($settings['phone'], 4).'</div>';
				}
				if(!empty($settings['mail'])){ 
					echo '<div class="contact_item email"><i class="fal fa-at"></i>'.$settings['mail'].'</div>';
				}
				if($settings['show_social'] === 'yes'){
					echo \mweb_theme_template_part::mweb_social_icons();
				} 
			
		echo '</div></div>';
			

	}

	
	protected function _content_template() {
		
	}
}



/**
 * Elementor Footer About
 * @since 1.0.0
 */
class My_Footer_About extends Widget_Base {

	
	public function get_name() {
		return 'my-footer-about';
	}
	
	public function get_title() {
		return __( 'درباره سایت', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-testimonial';
	}

	public function get_categories() {
		return [ 'digiacademy_footer' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'description' => ''
			]
		);
		
		$this->add_control(
			'desc',
			[
				'label' => __( 'متن', 'mweb' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		
		$this->add_control(
			'color',
			[
				'label' => __( 'رنگ عنوان', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elm_widget .widget_head' => 'color: {{VALUE}}',
				]
			]
		);
		
		$this->add_control(
			'color_desc',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elm_widget.widget .about_content' => 'color: {{VALUE}}',
				]
			]
		);
		
		
		$this->end_controls_section();


		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		echo '<div class="widget about-widget elm_widget"><div class="widget_head">'.$settings['title'].'</div><div class="widget-content"><div class="about_content">'.$settings['desc'].'</div></div></div>';
		
	}

	
	protected function _content_template() {
		
	}
}




/**
 * Elementor Footer About
 * @since 1.0.0
 */
class My_Footer_GoUp extends Widget_Base {

	
	public function get_name() {
		return 'my-footer-gototop';
	}
	
	public function get_title() {
		return __( 'رفتن به بالا', 'mweb' );
	}

	public function get_icon() {
		return 'eicon-divider';
	}

	public function get_categories() {
		return [ 'digiacademy_footer' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'تنظیمات', 'mweb' ),
			]
		);
		
		$this->add_control(
			'nav_type',
			[
				'label' => __( 'نوع', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'n_style_1'  => __( 'یک', 'mweb' ),
					'n_style_2' => __( 'دو', 'mweb' ),
				],
				'default' => 'n_style_1',
			]
		);
		
		$this->add_control(
			'background',
			[
				'label' => __( 'رنگ پس زمینه', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gototop' => 'background-color: {{VALUE}}',
				]
			]
		);
	
		$this->add_control(
			'color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gototop' => 'color: {{VALUE}}',
					'{{WRAPPER}} .gototop span' => 'color: {{VALUE}}',
				]
			]
		);
		
		$this->end_controls_section();


		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		if($settings['nav_type'] == 'n_style_1') {
			echo '<div class="gototop elm_gtp1"><i class="fal fa-angle-up"></i><span>رفتن به بالا</span></div>';
		}else{
			echo '<div class="gototop elm_gtp2"><i class="fal fa-angle-up"></i></div>';
		}
		
	}

	
	protected function _content_template() {
		
	}
}