<?php
namespace ElementorMahdisweb\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Testimonial Slider
 * @since 1.0.0
 */
class Block_Testimonial_Slider extends Widget_Base {

	
	public function get_name() {
		return 'block-testimonial-slider';
	}

	
	public function get_title() {
		return __( 'نظرات کاربران', 'mweb' );
	}

	
	public function get_icon() {
		return 'eicon-comments';
	}

	
	public function get_categories() {
		return [ 'digiacademy' ];
	}


	
	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'محتوا', 'mweb' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'el_title',
			[
				'label' => __( 'نام', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'el_post',
			[
				'label' => __( 'سمت', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'el_content',
			[
				'label' => __( 'توضیحات', 'mweb' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'el_avatar',
			[
				'label' => __( 'تصویر', 'mweb' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				]
			]
		);
		
		$this->add_control(
			'list',
			[
				'label' => __( 'ایتم ها', 'mweb' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ el_title }}}',
			]
		);
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'نمایش', 'mweb' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$slides_to_show = range( 1, 10 );
		$slides_to_show = array_combine( $slides_to_show, $slides_to_show );
		
		$this->add_responsive_control(
			'slides_to_show',
			[
				'label' => __( 'اسلاید جهت نمایش', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'' => __( 'پیشفرض', 'mweb' ),
				] + $slides_to_show,
				'default' => 3,
			]
		);
		
		$this->add_control(
			'navigation',
			[
				'label' => __( 'جهت بندی', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'both',
				'options' => [
					'both' => __( 'فلش و دکمه', 'mweb' ),
					'arrows' => __( 'فلش', 'mweb' ),
					'dots' => __( 'دکمه', 'mweb' ),
					'none' => __( 'هیچ', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'autoplay',
			[
				'label' => __( 'پخش خودکار', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);

		$this->add_control(
			'pause_on_hover',
			[
				'label' => __( 'توقف در هاور', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'infinite',
			[
				'label' => __( 'حلقه بی نهایت', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		$this->add_control(
			'overflow',
			[
				'label' => __( 'حذف چهارچوب', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);
		
		$this->add_control(
			'is_3d',
			[
				'label' => __( 'سه بعدی', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'yes' => __( 'بله', 'mweb' ),
					'no' => __( 'خیر', 'mweb' ),
				]
			]
		);


		$this->end_controls_section();
		
		
		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		$show_dots = ( in_array( $settings['navigation'], [ 'dots', 'both' ] ) );
		$show_arrows = ( in_array( $settings['navigation'], [ 'arrows', 'both' ] ) );
		
		$data_setting = array();
		
		$data_setting['slidesPerView'] = 1;
		$data_setting['spaceBetween'] = 10;
		$data_setting['watchSlidesVisibility'] = true;
		
		if( $settings['infinite'] == 'yes'){
			$data_setting['loop'] = true;
		}
		if( $settings['autoplay'] == 'yes'){
			$data_setting['autoplay'] = true;
		}
		if( $settings['pause_on_hover'] == 'yes'){
			$data_setting['touchMoveStopPropagation'] = true;
		}
		
		if($settings['is_3d'] == 'yes'){
			$data_setting['effect'] = 'coverflow';
			$data_setting['grabCursor'] = true;
			//$data_setting['slidesPerView'] = 'auto';
			$data_setting['coverflowEffect'] = array('rotate' => 30, 'stretch' => 0, 'depth' => 100, 'modifier' => 1, 'slideShadows' => true);
		}
		
		if( $show_dots ){
			$data_setting['pagination'] = array('el' => '.mweb-swiper-pagination','clickable' => true);
		}
		if( $show_arrows ){
			$data_setting['navigation'] = array('nextEl' => '.mweb-swiper-next','prevEl' => '.mweb-swiper-prev' );
		}
		
		
		
		$slide_tablet = empty($settings['slides_to_show_tablet']) ? 2 : $settings['slides_to_show_tablet'];
		$slide_mobile = empty($settings['slides_to_show_mobile']) ? 1 : $settings['slides_to_show_mobile'];

		$data_setting['breakpoints'] = array('575' => array('slidesPerView' => $slide_mobile), '768' => array('slidesPerView' => $slide_tablet), '1024' => array('slidesPerView' => $settings['slides_to_show']));
			
		$arrow_ico = 'fa-long-arrow-alt';	
			
		$attr_class = 'swiper-slider swiper-container';
		if($settings['overflow'] == 'yes'){
			$attr_class .= ' swiper-wrap-visible';
		}
		
		$this->add_render_attribute( [
			'carousel-wrapper' => [
				'class' => $attr_class,
				'id' => 'sl_'.$this->get_id(),
				'dir' => 'rtl',
				'data-slider' => wp_json_encode($data_setting)
			],
		] );
		
		
		if ( $settings['list'] ) {
			echo '<div class="mweb-swiper">';
			echo '<div '. $this->get_render_attribute_string( 'carousel-wrapper' ) .'>';
				echo '<div class="swiper-wrapper">';
				foreach (  $settings['list'] as $item ) {
					echo '<div class="swiper-slide">';
					echo '<div class="el_testimonial elementor-repeater-item-' . $item['_id'] . '">';
						echo '<div class="el_testimonial_author">';
							echo '<img class="el_testimonial_avatar" src="'.esc_url(  $item['el_avatar']['url'] ).'" />';
							echo '<h5>'.$item['el_title'].'</h5>';
							echo '<span>'.$item['el_post'].'</span>';
						echo '</div>';
						echo '<div class="el_testimonial_content">'.$item['el_content'].'</div>';
					echo '</div>';
					echo '</div>';
				}
			echo '</div>';	
				if ( $show_dots ) { 
					echo '<div class="mweb-swiper-pagination"></div>';
				} 
				if ( $show_arrows ){
					echo '<div class="mweb-swiper-next"><i class="fal '.$arrow_ico.'-right"></i></div><div class="mweb-swiper-prev"><i class="fal '.$arrow_ico.'-left"></i></div>';
				}			
			echo '</div>';
			echo '</div>';
		}
		
		
	}

	
	protected function _content_template() {
		
	}
}
