<?php
namespace ElementorMahdisweb\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Featured Service
 * @since 1.0.0
 */
class Block_Featured_Service extends Widget_Base {

	
	public function get_name() {
		return 'block-featured-service';
	}

	
	public function get_title() {
		return __( 'آیکن همراه با عنوان و توضیح', 'mweb' );
	}

	
	public function get_icon() {
		return 'eicon-post-content';
	}

	
	public function get_categories() {
		return [ 'digiacademy' ];
	}


	
	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'محتوا', 'mweb' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'el_title',
			[
				'label' => __( 'عنوان', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'el_subtitle',
			[
				'label' => __( 'توضیحات', 'mweb' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'el_icon',
			[
				'label' => __( 'آیکن', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'fal fa-box-open',
				'description' => 'https://fontawesome.com/icons?d=gallery&s=light'
			]
		);
		$this->add_control(
			'el_style',
			[
				'label' => __( 'نوع', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'type_one',
				'options' => [
					'type_one'  => __( 'یک', 'mweb' ),
					'type_two' => __( 'دو', 'mweb' )
				],
			]
		);
		
		$this->add_control(
			'el_color',
			[
				'label' => __( 'رنگ متن', 'mweb' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .el_featured_service h3' => 'color: {{VALUE}}',
					'{{WRAPPER}} .el_featured_service i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .el_featured_service p' => 'color: {{VALUE}}',
				]
			]
		);
		
		$this->add_group_control(
			'background',
			[
				'name' => 'el_background',
				'label' => __( 'رنگ پوشش', 'mweb' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .el_featured_service.type_one:before ,{{WRAPPER}} .el_featured_service.type_two'
			]
		);
		
		$this->add_control(
			'el_link',
			[
				'label' => __( 'لینک', 'mweb' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'mweb' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		
		
		
		$this->end_controls_section();
		
		
		
		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();

		
		echo '<div class="el_featured_service '.$settings['el_style'].'">';	
			if(!empty($settings['el_link']['url'])){
				$target = $settings['el_link']['is_external'] ? ' target="_blank"' : '';
				$nofollow = $settings['el_link']['nofollow'] ? ' rel="nofollow"' : '';
				echo '<a href="' . esc_url( $settings['el_link']['url'] ) . '" title="' . esc_attr( $settings['el_title'] ) . '" ' . $target . $nofollow . '>';
			}
				if($settings['el_icon']){
					echo '<i class="'.$settings['el_icon'].'"></i>';	
				}
				echo '<h3>'.$settings['el_title'].'</h3>';
				echo '<p>'.$settings['el_subtitle'].'</p>';
			
			if(!empty($settings['el_link']['url'])){
				echo '</a>';
			}
		
		echo '</div>';	
				
	}

	
	protected function _content_template() {
		
	}
}
