<?php
namespace ElementorMahdisweb\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Blog List
 * @since 1.0.0
 */
class Block_Blog_List extends Widget_Base {

	
	public function get_name() {
		return 'block-post-list';
	}

	
	public function get_title() {
		return __( 'وبلاگ افقی', 'mweb' );
	}

	
	public function get_icon() {
		return 'eicon-post-list';
	}

	
	public function get_categories() {
		return [ 'digiacademy' ];
	}


	
	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'عنوان', 'mweb' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان بلاک', 'mweb' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'icon',
			[
				'label' => __( 'آیکن', 'mweb' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'fa-book-reader',
				'description' => 'https://fontawesome.com/icons?d=gallery&s=light'
			]
		);
		$this->add_control(
			'title_url',
			[
				'label' => __( 'لینک', 'mweb' ),
				'type' => Controls_Manager::URL,
				'show_external' => false,
				'placeholder' => __( 'https://your-link.com', 'mweb' ),
			]
		);

		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'section_filter',
			[
				'label' => __( 'فیلتر', 'mweb' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'category_id',
			[
				'label' => __( 'انتخاب دسته بندی', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 0,
				'options' => get_element_category_list(),
			]
		);
		$this->add_control(
			'category_ids',
			[
				'label' => __( 'انتخاب دسته بندی ها', 'mweb' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'default' => '',
				'options' => get_element_category_multiple_list(),
			]
		);
		$this->add_control(
			'orderby',
			[
				'label' => __( 'مرتب سازی', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'date_post',
				'options' => get_element_post_orderby(),
			]
		);
		$this->add_control(
			'authors',
			[
				'label' => __( 'فیلتر نویسنده', 'mweb' ),
				'type' => Controls_Manager::SELECT,
				'default' => 0,
				'options' => get_element_author_list(),
			]
		);
		$this->add_control(
			'posts_per_page',
			[
				'label' => __( 'تعداد مطالب', 'mweb' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 4,
				'min' => 1,
			]
		);
		$this->add_control(
			'offset',
			[
				'label' => __( 'نقطه شروع مطالب', 'mweb' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '',
				'description' => 'offset باعث می شود چند نتیجه اول را رد کند و از آنجا به بعد تعداد پست به شما دهد',
			]
		);

		$this->end_controls_section();
		

		
	}

	
	protected function render() {
		$settings = $this->get_settings_for_display();
		$query_options = array('category_id' => $settings['category_id'],'posts_per_page' => $settings['posts_per_page'],'orderby' => $settings['orderby'],'authors' => $settings['authors'],'offset' => $settings['offset'],'post_type' => 'post' );
		
		$block_options = array('block_id' => 'bk_'.$this->get_id() ,'block_name' => 'mweb_blog_arch', 'block_options' => array('title' => $settings['title'],'icon' => $settings['icon'],'title_url' => $settings['title_url']['url'] ));
		
		$block_options['block_options'] = array_merge($block_options['block_options'],$query_options);
		
		
		$query_data = \mweb_theme_query::get_custom_query( $query_options );

		echo \mweb_theme_block::block_open( $block_options, $query_data );
		echo \mweb_theme_block::block_header( $block_options );
		echo \mweb_theme_block::block_content_open();
		
			//check empty
			if ( $query_data->have_posts() ) {
				echo \mweb_theme_block::mweb_blog_horizontal( $query_data, $block_options['block_options'] );
			} else {
				echo \mweb_theme_block::no_content();
			}
			//reset post data
			wp_reset_postdata();
			
		echo \mweb_theme_block::block_content_close();
		echo \mweb_theme_block::block_footer( $block_options );
		echo \mweb_theme_block::block_close(); 
		
	}

	
	protected function _content_template() {
		
	}
}
