<?php

//register widget area

function mweb_widgets_init() {


	//blog home section
	register_sidebar(
		array(
			'id'            => 'home_sidebar',
			'name'          => esc_attr__( 'سایدبار', 'mweb' ),
			'description'   => esc_attr__( '', 'mweb' ),
			'before_widget' => '<div class="widget %2$s">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<div class="widget_title"><span>',
			'after_title'   => '</span></div><div class="widget-content">'
		)
	);

	register_sidebar(
	array(
		'id'            => 'single_downads',
		'name'          => esc_attr__( 'تبلیغات ادامه مطلب', 'mweb' ),
		'description'   => esc_attr__( 'تبلیغات زیر مطالب - ابزارک رو بدون عنوان استفاده کنید', 'mweb' ),
		'before_widget' => '',
		'after_widget'  => '',
		'before_title'  => '',
		'after_title'   => ''
		)
	);

	register_sidebar(
		array(
			'id'            => 'myaccount_sidebar',
			'name'          => esc_attr__( 'سایدبار حساب کاربری', 'mweb' ),
			'description'   => esc_attr__( '', 'mweb' ),
			'before_widget' => '<div class="widget %2$s">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<div class="widget_title">',
			'after_title'   => '</div><div class="widget-content">'
		)
	);

	register_sidebar(
		array(
			'id'            => 'vendor_sidebar',
			'name'          => esc_attr__( 'سایدبار فروشنده', 'mweb' ),
			'description'   => esc_attr__( '', 'mweb' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div></aside>',
			'before_title'  => '<div class="widget_title"><span>',
			'after_title'   => '</span></div><div class="widget-content">'
		)
	);
	
	if(is_learndash_activated()){
		register_sidebar(
			array(
				'id'            => 'ld_sidebar',
				'name'          => esc_attr__( 'لرن دش - سایدبار دوره', 'mweb' ),
				'description'   => esc_attr__( '', 'mweb' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div></aside>',
				'before_title'  => '<div class="widget_title"><span>',
				'after_title'   => '</span></div><div class="widget-content">'
			)
		);
	}



	$footer_column = mweb_theme_util::get_theme_option('mweb_footer_column');
	if(!empty($footer_column)){
		$my_column = explode('_',$footer_column);
		if(is_array($my_column)){
			foreach( $my_column as $key => $col ){
				register_sidebar(
					array(
						'name'          => 'بخش'.((int)$key+1).'پابرگ',
						'id'            => 'mweb_footer_sidebar'.$key,
						'before_widget' => '<div id="%1$s" class="widget %2$s">',
						'after_widget'  => '</div></div>',
						'before_title'  => '<div class="widget_head">',
						'after_title'   => '</div><div class="widget-content">'
					)
				); //#foreach
				
				
			}
			
		}
		
	}

	//registering sidebar sections
	if ( get_option( 'mweb_custom_multi_sidebars', false ) ) {
		$mweb_theme_current_sidebars = get_option( 'mweb_custom_multi_sidebars', '' );
		if ( ! empty( $mweb_theme_current_sidebars ) && is_array( $mweb_theme_current_sidebars ) ) {
			foreach ( $mweb_theme_current_sidebars as $mweb_current_sidebar ) {
				register_sidebar(
					array(
						'name'          => $mweb_current_sidebar['name'],
						'id'            => $mweb_current_sidebar['id'],
						'before_widget' => '<div id="%1$s" class="widget %2$s">',
						'after_widget'  => '</div></div>',
						'before_title'  => '<div class="widget_title"><span>',
						'after_title'   => '</span></div><div class="widget-content">'
					)
				); //#foreach
			};
		};
	};


}
add_action( 'widgets_init', 'mweb_widgets_init' );