<?php

/**
 * Class mweb_theme_single
 * This file support feature for single post
 */
if ( ! class_exists( 'mweb_theme_single' ) ) {
	class mweb_theme_single {


		

		/**-------------------------------------------------------------------------------------------------------------------------
		 * @return mixed|string
		 * get sidebar position setting
		 */
		static function get_sidebar_position() {

			//sidebar position
			$post_id          = get_the_ID();
			$sidebar_position = get_post_meta( $post_id, 'mweb_sidebar_position', true );

			//override sidebar position
			if ( 'default' == $sidebar_position || empty( $sidebar_position ) ) {
				$sidebar_position = mweb_theme_util::get_theme_option( 'single_sidebar_position' );
			}

			return $sidebar_position;
		}

		
		/**-------------------------------------------------------------------------------------------------------------------------
		 * @return mixed|string
		 * get first_paragraph setting
		 */
		static function check_comment_box() {

			$mweb_comment_box = get_post_meta( get_the_ID(), 'mweb_single_comment_box', true );
			if ( 'default' == $mweb_comment_box || empty( $mweb_comment_box ) ) {
				$mweb_comment_box = mweb_theme_util::get_theme_option( 'mweb_single_comment' );
			};

			return $mweb_comment_box;
		}
		

		
		/**-------------------------------------------------------------------------------------------------------------------------
		 * get breadcrumbs
		 */

		static function mweb_get_breadcrumbs($has_container = true, $after_wrap = '', $is_custom = false) {
			   
			$showOnHome = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
			$delimiter = ''; // delimiter between crumbs
			$home = 'صفحه نخست'; // text for the 'Home' link
			$showCurrent = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show
			$before = '<li class="active"><span>'; // tag before the current crumb
			$after = '</span></li>'; // tag after the current crumb

			global $post;
			$homeLink = get_bloginfo('url');
			$classes = empty($classes) ? '' : $classes;			
			$inner_class = $is_custom == false ? 'breadcrumb breadcrumb-arrow' : 'woocommerce-breadcrumb';	
			if($has_container){
				echo '<div class="col-12">';
			}
			
			if (is_home() || is_front_page()) {

				if ($showOnHome == 1) echo '<ol class="'.$inner_class.'">'.$after_wrap.'<li><a href="' . $homeLink . '">' . $home . '</a></li></ol>';

			} else {

				echo '<ol class="'.$inner_class.'">'.$after_wrap.'<li><a href="' . $homeLink . '">' . $home . '</a> ' . $delimiter . '</li> ';

				if ( is_category() ) {
				$thisCat = get_category(get_query_var('cat'), false);
				if ($thisCat->parent != 0) echo get_category_parents($thisCat->parent, TRUE, ' ' . $delimiter . ' ');
				echo $before . '' . single_cat_title('', false) . '' . $after;

				} elseif ( is_search() ) {
				echo $before . 'جستجو برای"' . get_search_query() . '"' . $after;

				} elseif ( is_day() ) {
				echo '<li><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . '</li> ';
				echo '<li><a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $delimiter . '</li> ';
				echo $before . get_the_time('d') . $after;

				} elseif ( is_month() ) {
				echo '<li><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . '</li> ';
				echo $before . get_the_time('F') . $after;

				} elseif ( is_year() ) {
				echo $before . get_the_time('Y') . $after;

				} elseif ( is_single() && !is_attachment() ) {
				  if ( get_post_type() != 'post' ) {
					$post_type = get_post_type_object(get_post_type());
					$slug = $post_type->rewrite;
					echo '<li><a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a></li>';
					if ($showCurrent == 1) echo ' ' . $delimiter . ' ' . $before . get_the_title() . $after;
				  } else {
					$cat = get_the_category(); $cat = $cat[0];
					$cats = get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
					if ($showCurrent == 0) $cats = preg_replace("#^(.+)\s$delimiter\s$#", "$1", $cats);
					$cat_parents = explode(',',$cats);
					  
					// Loop through parent categories and store in variable $cat_display
					$cat_display = '';
					foreach($cat_parents as $parents) {
						$cat_display .= '<li>'.$parents.'</li>';
					}
					echo $cat_display;
					//if ($showCurrent == 1) echo $before . get_the_title() . $after;
				}

				} elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
				$post_type = get_post_type_object(get_post_type());
				echo $before . $post_type->labels->singular_name . $after;

				} elseif ( is_attachment() ) {
				$parent = get_post($post->post_parent);
				$cat = get_the_category($parent->ID); $cat = $cat[0];
				echo get_category_parents($cat, TRUE, ' ' . $delimiter . '</li> ');
				echo '<li><a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a>';
				if ($showCurrent == 1) echo ' ' . $delimiter . '</li> ' . $before . get_the_title() . $after;

				} elseif ( is_page() && !$post->post_parent ) {
				if ($showCurrent == 1) echo $before . get_the_title() . $after;

				} elseif ( is_page() && $post->post_parent ) {
				$parent_id = $post->post_parent;
				$breadcrumbs = array();
				while ($parent_id) {
				$page = get_page($parent_id);
				$breadcrumbs[] = '<li><a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
				$parent_id = $page->post_parent;
				}
				$breadcrumbs = array_reverse($breadcrumbs);
				for ($i = 0; $i < count($breadcrumbs); $i++) {
				echo $breadcrumbs[$i];
				if ($i != count($breadcrumbs)-1) echo ' ' . $delimiter . '</li> ';
				}
				if ($showCurrent == 1) echo ' ' . $delimiter . '</li> ' . $before . get_the_title() . $after;

				} elseif ( is_tag() ) {
				echo $before . 'Posts tagged "' . single_tag_title('', false) . '"' . $after;

				} elseif ( is_author() ) {
				global $author;
				$userdata = get_userdata($author);
				echo $before . 'Articles posted by ' . $userdata->display_name . $after;

				} elseif ( is_404() ) {
				echo $before . 'Error 404' . $after;
				}

				if ( get_query_var('paged') ) {
				if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
				echo __('Page') . ' ' . get_query_var('paged');
				if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
				}

				echo '</ol>';

			}
			
			if($has_container){
				echo '</div>';
			}
		} // breadcrumbs


		

	}

}
