<?php
/**
 * Class mweb_theme_shortcode
 */
if ( ! class_exists( 'mweb_theme_shortcode' ) ) {
	class mweb_theme_shortcode {
		
		
	/**
	 * register supportcode
	 */
	function __construct() {

		
		//add shortcodes
		add_shortcode( 'button', array( $this, 'mweb_button' ) );
		add_shortcode( 'media', array( $this, 'mweb_media' ) );
		add_shortcode( 'accordion', array( $this, 'mweb_accordion_group' ) );
		add_shortcode( 'accordion-item', array( $this, 'mweb_accordion_item' ) );
		add_shortcode( 'row', array( $this, 'mweb_row' ) );
		add_shortcode( 'column', array( $this, 'mweb_column' ) );
		add_shortcode( 'dlline', array( $this, 'mweb_dlline' ) );
		add_shortcode( 'myaudio', array( $this, 'mweb_my_audio' ) );
		add_shortcode( 'dlbox', array( $this, 'mweb_dlbox' ) );
		add_shortcode( 'blockquote', array( $this, 'mweb_blockquote' ) );
		add_shortcode( 'table_price', array( $this, 'mweb_table_price' ) );
		add_shortcode( 'table_price_item', array( $this, 'mweb_table_price_item' ) );
		add_shortcode( 'list_positive', array( $this, 'mweb_list_positive' ) );
		add_shortcode( 'list_negative', array( $this, 'mweb_list_negative' ) );


	}


	

	/**-------------------------------------------------------------------------------------------------------------------------
	 * @param null $content
	 *
	 * @return string
	 */
	static function shortcodes_helper( $content = null ) {
		$content = do_shortcode( shortcode_unautop( $content ) );
		$content = preg_replace( '#^<\/p>|^<br \/>|<p>$#', '', $content );
		$content = preg_replace( '#<br \/>#', '', $content );

		return trim( $content );
	}

	
	
	/**-------------------------------------------------------------------------------------------------------------------------
	 * Shortcode button
	 */
	static function mweb_button( $attrs, $content = null ) {
		extract( shortcode_atts( array(
			'type'   => '',
			'color'  => '',
			'target' => '',
			'link'   => ''
		), $attrs ) );

		$classes      = array();
		$style_inline = '';
		$str          = '';

		$classes[] = 'btn btn-shortcode';
		if ( ! empty( $type ) ) {
			$classes[] = 'is-' . strip_tags( $type );
		} else {
			$classes[] = 'is-default';
		}

		if ( ! empty( $color ) ) {
			$style_inline = 'style="background-color: ' . strip_tags( $color ) . '"';
		}

		if ( ! empty( $link ) ) {
			$link = esc_url( $link );
		} else {
			$link = '#';
		}

		if ( ! empty( $target ) ) {
			$target = 'target="blank"';
		}else{
			$target = '';
		}

		$classes = implode( ' ', $classes );

		$str .= '<a class="' . $classes . '" ' . $style_inline . ' ' . $target . ' href="' . $link . '">';
		$str .= esc_attr( $content );
		$str .= '</a>';

		return $str;

	}
	
	
	
	/**-------------------------------------------------------------------------------------------------------------------------
	 * Shortcode media aparat
	 */
	static function mweb_media( $attrs) {
		extract( shortcode_atts( array(
			'id' => '',
			'type' => '',
		), $attrs ) );

		$classes   = array();
		$classes[] = 'media-shortcode';

		if ( empty( $type ) ) {
			$classes[] = 'aparat';
		} else {
			$classes[] = 'is-' . esc_attr( $type );
		}

		$classes = implode( ' ', $classes );

		return '<div class="' . esc_attr( $classes ) . '"><span style="display: block;padding-top: 57%"></span><iframe src="https://www.aparat.com/video/video/embed/videohash/'.$id.'/vt/frame" allowFullScreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" ></iframe></div>';
	}
	
	
	/**-------------------------------------------------------------------------------------------------------------------------
	 * Shortcode List Positive
	 */

	static function mweb_list_positive( $attrs, $content = null ) {
		return '<div class="el_list e_positive">' . self::shortcodes_helper( $content ) . ' </div>';
	}
	
	
	/**-------------------------------------------------------------------------------------------------------------------------
	 * Shortcode List Negative
	 */

	static function mweb_list_negative( $attrs, $content = null ) {
		return '<div class="el_list e_negative">' . self::shortcodes_helper( $content ) . ' </div>';
	}
	
	
	
	/**-------------------------------------------------------------------------------------------------------------------------
	 * Shortcode accordion
	 */

	static function mweb_accordion_group( $attrs, $content = null ) {
		return '<div class="accordion accordion-shortcode">' . self::shortcodes_helper( $content ) . ' </div>';
	}


	static function mweb_accordion_item( $attrs, $content = null ) {
		extract( shortcode_atts( array(
			'title' => '',
		), $attrs ) );

		if ( empty( $title ) ) {
			$title = '';
		}

		$str = '';
		$str .= '<h3 class="accordion-item-title">' . $title . '</h3>';
		$str .= '<div class="accordion-item-content accordion-hide">' . self::shortcodes_helper( $content ) . '</div>';

		return $str;

	}
	
	
	
	/**-------------------------------------------------------------------------------------------------------------------------
	 * Shortcode table price
	 */

	static function mweb_table_price( $attrs, $content = null ) {
		extract( shortcode_atts( array(
			'name' => '',
			'active' => '',
			'price' => '',
			'period' => '',
			'button' => '',
			'link' => '',
			'color' => ''
		), $attrs ) );
		
		$btn_color = $btn_attr = '';
		
		$tb_class = 'tb_price clear';
		if($active == 'yes'){
			$tb_class .= ' select';
			if(!empty($color))
			$btn_color = ' style="background-color:#'.$color.'"';
		}
		if(!empty($color) && $active != 'yes')
			$btn_attr = " onmouseover=\"this.style.background='#$color'\" onmouseout=\"this.style.background='#fbfbfb'\"";
		
		$my_color = empty($color) ? '' : ' style="background-color:#'.$color.'"';
		
		if(!empty($name))
		return '<div class="'.$tb_class.'"><h5'.$my_color.'>'.$name.'</h5><span>'.$price.'<i>'.$period.'</i></span>
					<ul>' . self::shortcodes_helper( $content ) . '</ul>
					<a class="tb_btn"'.$btn_color.$btn_attr.' href="'.$link.'">'.$button.'</a>
				</div>';

	}


	static function mweb_table_price_item( $attrs ) {
		extract( shortcode_atts( array(
			'title' => '',
			'class' => ''
		), $attrs ) );
		
		$my_class = empty($class) ? '' : ' class="'.$class.'"';

		if ( !empty( $title ) ) 
			return '<li'.$my_class.'>'.$title.'</li>';

	}
	
	
	/**-------------------------------------------------------------------------------------------------------------------------
	 * Shortcode section 
	 */

	static function mweb_blockquote( $attrs, $content = null ) {
		extract( shortcode_atts( array(
			'author' => '',
		), $attrs ) );


		$str = '';
		$str .= '<blockquote class="blockquote">' . self::shortcodes_helper( $content );
		if(!empty($author)){
			$str .= '<span class="author_label">'.$author.'</span>';
		}
		$str .= '</blockquote>';

		return $str;

	}
	
	
	/**-------------------------------------------------------------------------------------------------------------------------
	 * Shortcode application link
	 */

	static function mweb_dlline( $attrs ) {
		extract( shortcode_atts( array(
			'title' => '',
			'link' => '',
		), $attrs ) );

		if ( empty( $title ) ) {
			$title = '';
		}

		$str = '';

		// Return custom embed code
		$str .= '<div class="simple_dlbox"><a href="'.$link.'" target="_blank">
		<span class="simple_dlbox_title">'.$title.'</span><span class="simple_dlbox_btn">دریافت</span></a></div>';
	
		return $str;

	}
	
	
	/**-------------------------------------------------------------------------------------------------------------------------
	 * Shortcode audio
	 */
	static function mweb_my_audio( $attrs ) {
		extract( shortcode_atts( array(
			'link' => '',
		), $attrs ) );

	
		$str = '';
		if ( !empty( $link ) ) {
			$str .= '<audio controls><source src="'.$link.'" type="audio/mpeg">Your browser does not support the audio element.</audio>';
		}

		return $str;

	}
	
	
	
	
	/**-------------------------------------------------------------------------------------------------------------------------
	 * Shortcode dlbox
	 */
	static function mweb_dlbox( $attrs ) {
		extract( shortcode_atts( array(
			'title' => '',
			'link' => '',
		    'type' => '',
	     	'size' => '',
		    'pass' => '',
		), $attrs ) );

	
		$str = '';
			if ( !empty( $link ) ) {
				$str .= '<div class="download_box"><div class="download_box_title"><i class="fal fa-download"></i>'.$title.'</div>
				<div class="download_box_item">
				<i class="fal fa-file"></i>
				<span>نوع فایل : </span> '.$type.'
				</div>
				<div class="download_box_item">
				<i class="fal fa-file"></i>
				<span>حجم : </span> '.$size.'
				</div>';
					if ( !empty( $pass ) ) {
				$str .= '<div class="download_box_item">
				<i class="fal fa-lock"></i>
				<span>پسورد : </span> '.$pass.'
				</div>';
					}
				$str .= ' <a href="'.$link.'">دریافت</a>';
				$str .= '</div>';
					
			}

		return $str;

	}
	 

	 
	/**-------------------------------------------------------------------------------------------------------------------------
	 * Shortcode row
	 */
	static function mweb_row( $attrs, $content = null ) {

		return '<div class="row-shortcode row">' . self::shortcodes_helper( $content ) . '</div>';

	}
	
	
	
	
	
	/**-------------------------------------------------------------------------------------------------------------------------
	 * Shortcode column
	 */

	static function mweb_column( $attrs, $content = null ) {

		extract( shortcode_atts( array(
			'width' => ''
		), $attrs ) );

		if ( empty( $width ) ) {
			$width = '100%';
		}

		switch ( $width ) {
			case '50%'  :
				return '<div class="col-shortcode col-sm-6 col-12">' . self::shortcodes_helper( $content ) . '</div>';
			case '33%'  :
				return '<div class="col-shortcode col-sm-4 col-12">' . self::shortcodes_helper( $content ) . '</div>';
			case '66%' :
				return '<div class="col-shortcode col-sm-8 co-12">' . self::shortcodes_helper( $content ) . '</div>';
			case '25%' :
				return '<div class="col-shortcode col-sm-3 col-12">' . self::shortcodes_helper( $content ) . '</div>';
			default :
				return '<div class="col-shortcode col-12">' . self::shortcodes_helper( $content ) . '</div>';
		}
	}
		
		

	}
	new mweb_theme_shortcode();
}
