<?php

/**
 * Class mweb_theme_query
 * This file handling query data for theme
 */
if ( ! class_exists( 'mweb_theme_query' ) ) {
	class mweb_theme_query {
		
		
		/**
		 * @param $data_query
		 * @return WP_Query
		 * do search query
		 */
		static function mweb_query_search($search_data)
			{
				$args = array(
					's' => esc_sql($search_data),
					'post_type' => array('product'),
					'post_status' => 'publish',
				);

				$data_query = new WP_Query($args);
				return $data_query;
			}
		

		 
		 /**
		 * @param $data_query
		 * @return WP_Query
		 * do search query
		 */
		static function mweb_query_discount( $array_arg ='' )
			{
				
				extract( shortcode_atts(
					array(
						'array_range'      => '',
						'posts_per_page'   => '',
						), $array_arg
					)
				);
			
				if(!empty($array_range))
				$array_range_tmp = explode('-',$array_range);

				$args = array(
					'post_type'  => 'product',
					'meta_key'   => '_discount',
					'orderby'    => '_discount',
					'posts_per_page' => $posts_per_page,
					'order'      => 'ASC',
					'meta_query' => array(
						array(
							'key'     => '_discount',
							'value'   => $array_range_tmp,
							'compare' => 'BETWEEN',
							'type'	=> 'NUMERIC'
							),
						)
				);

				$data_query = new WP_Query($args);
				return $data_query;
			}
			
			
			
		/**
		 * @param $data_query
		 * @return WP_Query
		 * do relateg course query
		 */
		static function mweb_get_related_courses( $limit ) {
			if ( ! $limit ) {
				$limit = 3;
			}
			$course_id = get_the_ID();

			$tag_ids = wp_get_object_terms( $course_id, 'course_category', array('fields' => 'ids') );
			/* $tags    = get_the_terms( $course_id, 'course_category' );

			if ( $tags ) {
				foreach ( $tags as $individual_tag ) {
					$tag_ids[] = $individual_tag->term_id;
				}
			} */

			$args = array(
				'posts_per_page'      => $limit,
				'paged'               => 1,
				'ignore_sticky_posts' => 1,
				'post__not_in'        => array( $course_id ),
				'post_type'           => 'lp_course'
			);

			if ( $tag_ids ) {
				$args['tax_query'] = array(
					array(
						'taxonomy' => 'course_category',
						'field'    => 'id',
						'terms'    => $tag_ids
					)
				);
			}
			$related = new WP_Query( $args );

			return $related;
		}	
		
		
		
		/**
		 * @param $data_query
		 * @return WP_Query
		 * do relateg learndash course query
		 */
		static function mweb_get_related_ld_courses( $limit ) {
			if ( ! $limit ) {
				$limit = 3;
			}
			$course_id = get_the_ID();

			$tag_ids = wp_get_object_terms( $course_id, 'ld_course_category', array('fields' => 'ids') );
		
			$args = array(
				'posts_per_page'      => $limit,
				'paged'               => 1,
				'ignore_sticky_posts' => 1,
				'post__not_in'        => array( $course_id ),
				'post_type'           => 'sfwd-courses'
			);

			if ( $tag_ids ) {
				$args['tax_query'] = array(
					array(
						'taxonomy' => 'ld_course_category',
						'field'    => 'id',
						'terms'    => $tag_ids
					)
				);
			}
			$related = new WP_Query( $args );

			return $related;
		}
			


		/**-------------------------------------------------------------------------------------------------------------------------
		 * @param string $args
		 * @param string $paged
		 *
		 * @return WP_Query
		 * get custom query
		 */
		static function get_custom_query( $args = '', $paged = '' ) {
			extract( shortcode_atts(
				         array(
							 'post_type'      => '',
					         'category_ids'   => '',
					         'category_id'    => '',
					         'author_id'      => '',
					         'tags'           => '',
					         'tag_in'         => '',
							 'post_format'    => '',
					         'posts_per_page' => '',
					         'no_found_rows'  => '',
					         'offset'         => '',
					         'orderby'        => '',
					         'post_types'     => '',
					         'meta_key'       => '',
							 'post__in '	  => '',
					         'post_not_in'    => '',
							 
				         ), $args
			         )
			);

			//default query config
			$args_query                        = array();
			$args_query['ignore_sticky_posts'] = 1;
			$args_query['post_status']         = 'publish';
			
			if ( empty( $post_type ) ) {
				$args_query['post_type'] = 'post';
			}else {
				$args_query['post_type'] = $post_type;
			}

			//no found rows query
			if ( ! empty( $no_found_rows ) ) {
				$args_query['no_found_rows'] = true;
			}

			if ( ! empty( $post_not_in )) {
				$args_query['post__not_in'] = explode( ',', $post_not_in );
			}
			
			if ( ! empty( $post__in )) {
				$args_query['post__in'] = explode( ',', $post__in );
			}

			//post per page
			if ( empty( $posts_per_page ) ) {
				$args_query['posts_per_page'] = 5;
			} else {
				$args_query['posts_per_page'] = $posts_per_page;
			};


			//categories query
			if ( ! empty( $category_ids ) ) {
				//check categories
				if ( is_array( $category_ids ) ) {
					$category_ids = implode( ',', $category_ids );
				}

				if ( ! empty( $category_ids ) ) {
					$args_query['cat'] = esc_attr( $category_ids );
				} else {
					if ( ! empty( $category_id ) ) {
						$args_query['cat'] = $category_id;
					}
				}
				
			} else {
				if ( ! empty( $category_id ) ) {
					
					switch($post_type){
						
						case 'product':
							$args_query['tax_query'] = array(
								array(
									'taxonomy' => 'product_cat',
									'terms'    => $category_id
								)
							);
							break;
							
						case 'slider':
							$args_query['tax_query'] = array(
								array(
									'taxonomy' => 'slider_category',
									'terms'    => $category_id
								)
							);
							break;
							
						case 'lp_course':
							$args_query['tax_query'] = array(
								array(
									'taxonomy' => 'course_category',
									'terms'    => $category_id
								)
							);
							break;
							
						case 'sfwd-courses':
							$args_query['tax_query'] = array(
								array(
									'taxonomy' => 'ld_course_category',
									'terms'    => $category_id
								)
							);
							break;	
						
						default:
						$args_query['cat'] = $category_id;

					}

				}
			}
			
			//post format
			if ( ! empty( $post_format ) ) {
				if ( 'default' != $post_format ) {
					$args_query['tax_query'] = array(
						array(
							'taxonomy' => 'post_format',
							'field'    => 'slug',
							'terms'    => array( 'post-format-' . esc_attr( $post_format ) ),
						),
					);
				} else {
					$args_query['tax_query'] = array(
						array(
							'taxonomy' => 'post_format',
							'field'    => 'slug',
							'terms'    => array( 'post-format-gallery', 'post-format-video', 'post-format-audio' ),
							'operator' => 'NOT IN',
						),
					);
				}
			}


			
			
			

			//tags query
			if ( ! empty( $tags ) ) {
				$tags         = preg_replace( '/\s+/', '', $tags );
				$args_query['tag'] = esc_attr( $tags );
			}

			//tag in query
			if ( ! empty( $tag_in ) && is_array( $tag_in ) ) {
				$args_query['tag__in'] = $tag_in;
			}

			//author query
			if ( ! empty( $author_id ) ) {
				$args_query['author'] = $author_id;
			}

			//page query
			if ( ! empty( $paged ) ) {
				$args_query['paged'] = $paged;
			} else {
				$args_query['paged'] = 1;
			}

			//offset query
			if ( ! empty( $offset ) ) {
				if ( $paged > 1 ) {
					$args_query['offset'] = intval( $offset ) + intval( ( $paged - 1 ) * intval( $args_query['posts_per_page'] ) );
				} else {
					$args_query['offset'] = intval( $offset );
				}
			}


			//set default order by
			if ( empty( $orderby ) ) {
				$orderby = 'date_post';
			}

			//meta keys
			if ( ! empty( $meta_key ) ) {
				$args_query['meta_key'] = $meta_key;
			}

			switch ( $orderby ) {

				//date post
				case 'date_post' :
					$args_query['orderby'] = 'date';
					break;

				//popular comment
				case 'comment_count' :
					$args_query['orderby'] = 'comment_count';
					break;

				//post type
				case 'post_type' :
					$args_query['orderby'] = 'type';
					break;

				//popular views
				case 'popular':
					$param['meta_key'] = 'mweb_theme_view_total_forgery';
					$param['orderby']  = 'meta_value_num';
					$param['order']    = 'DESC';
					break;

				case 'popular_week':
					$param['meta_key'] = 'mweb_theme_week_view_total_num';
					$param['orderby']  = 'meta_value_num';
					$param['order']    = 'DESC';
					break;

				case 'top_review' :
					$param['meta_key'] = 'mweb_theme_as';
					$param['orderby']  = 'meta_value_num';
					$param['order']    = 'DESC';
					break;

				case 'last_review' :
					$param['meta_key'] = 'mweb_theme_as';
					$param['orderby']  = 'date';
					$param['order']    = 'DESC';
					break;

				//random
				case 'rand':
					$args_query['orderby'] = 'rand';
					break;
					
				//post__in
				case 'post__in':
					$args_query['orderby'] = 'post__in';
					break;

				//alphabet decs
				case 'alphabetical_order_decs':
					$args_query['orderby'] = 'title';
					$args_query['order']   = 'DECS';
					break;

				//alphabet asc
				case 'alphabetical_order_asc':
					$args_query['orderby'] = 'title';
					$args_query['order']   = 'ASC';
					break;
					
				case 'best_selling':
                    $args_query['meta_key']='total_sales';
					$args_query['orderby']='meta_value_num';
					$args_query['ignore_sticky_posts']   = 1;
					$args_query['meta_query'] = array();
					$args_query['meta_query'][] = WC()->query->stock_status_meta_query();
					$args_query['meta_query'][] = WC()->query->visibility_meta_query();
					break;
				case 'featured_product':
					$args_query['ignore_sticky_posts']=1;
					$args_query['tax_query'] = array();
					$args_query['tax_query'][] = array(
                        'taxonomy' => 'product_visibility',
                        'field'    => 'name',
                        'terms'    => 'featured',
                    );
					break;
				case 'top_rate':
				    $args_query['meta_key']='_wc_average_rating';
					$args_query['orderby']='meta_value_num';
					$args_query['meta_query'] = array();
					$args_query['meta_query'][] = WC()->query->stock_status_meta_query();
					$args_query['meta_query'][] = WC()->query->visibility_meta_query();
					break;
				case 'recent':
					$args_query['orderby'] = 'meta_value';
					$args_query['meta_key'] = '_stock_status';
					$args_query['meta_query'] = array();
					$args_query['meta_query'][] = WC()->query->stock_status_meta_query();
					$args_query['order']   = 'ASC';
					break;
				case 'on_sale':
					$args_query['meta_query'] = array();
					$args_query['meta_query'][] = WC()->query->stock_status_meta_query();
					$args_query['meta_query'][] = WC()->query->visibility_meta_query();
					$args_query['post__in'] = wc_get_product_ids_on_sale();
					break;
				case 'sale_course':
					$args_query['orderby'] = 'meta_value';
					$args_query['meta_key'] = '_lp_sale_price';
					//$args_query['meta_query'] = array();
					//$args_query['meta_query'][] = ;
					break;	
				
			}

			//get query
			$data_query = new WP_Query( $args_query );

			return $data_query;
		}
	}
}
