<?php

/**
 * Query WooCommerce activation
 */
if ( ! function_exists( 'is_woocommerce_activated' ) ) {
	function is_woocommerce_activated() {
		return class_exists( 'woocommerce' ) ? true : false;
	}
}

/**
 * Check if Dokan is activated
 */
if ( ! function_exists( 'is_dokan_activated' ) ) {
	function is_dokan_activated() {
		return class_exists( 'WeDevs_Dokan' ) ? true : false;
	}
}

/**
 * Check if LearnPress is activated
 */
if ( ! function_exists( 'is_learnpress_activated' ) ) {
	function is_learnpress_activated() {
		return class_exists( 'LearnPress' ) ? true : false;
	}
}

/**
 * Check if LearnDash is activated
 */
if ( ! function_exists( 'is_learndash_activated' ) ) {
	function is_learndash_activated() {
		return class_exists( 'SFWD_LMS' ) ? true : false;
	}
}

/**
 * Check if wc sms is activated
 */
if ( ! function_exists( 'is_wcsms_activated' ) ) {
	function is_wcsms_activated() {
		return class_exists( 'WoocommerceIR_SMS_Helper' ) ? true : false;
	}
}

/**
 * Check if Visual Composer is activated
 */
if( ! function_exists( 'is_vc_activated' ) ) {
	function is_vc_activated() {
		return class_exists( 'WPBakeryVisualComposerAbstract' ) ? true : false;
	}
}

/**
 * Check if Redux Framework is activated
 */
if( ! function_exists( 'is_redux_activated' ) ) {
	function is_redux_activated() {
		return class_exists( 'ReduxFrameworkPlugin' ) ? true : false;
	}
}

/**
 * Check if Invisible ReCaptcha is activated
 */
if( ! function_exists( 'is_recaptcha_activated' ) ) {
	function is_recaptcha_activated() {
		return class_exists( 'InvisibleReCaptcha' ) ? true : false;
	}
}


/**
 * Check if Restrict Content Pro is activated
 */
if( ! function_exists( 'is_rcp_activated' ) ) {
	function is_rcp_activated() {
		return class_exists( 'Restrict_Content_Pro' ) ? true : false;
	}
}


/**
 * Query WooCommerce Extension Activation.
 * @var  $extension main extension class name
 * @return boolean
 */
function is_woocommerce_extension_activated( $extension ) {

	if( is_woocommerce_activated() ) {
		$is_activated = class_exists( $extension ) ? true : false;
	} else {
		$is_activated = false;
	}

	return $is_activated;
}


/**
 * Checks if YITH Wishlist is activated
 *
 * @return boolean
 */
if( ! function_exists( 'is_yith_wcwl_activated' ) ) {
	function is_yith_wcwl_activated() {
		return is_woocommerce_extension_activated( 'YITH_WCWL' );
	}
}

/**
 * Checks if YITH filter is activated
 *
 * @return boolean
 */
if( ! function_exists( 'is_yith_wcan_activated' ) ) {
	function is_yith_wcan_activated() {
		return is_woocommerce_extension_activated( 'YITH_WCAN' );
	}
}

/**
 * Checks if YITH WooCompare is activated
 *
 * @return boolean
 */
if( ! function_exists( 'is_yith_woocompare_activated' ) ) {
	function is_yith_woocompare_activated() {
		return is_woocommerce_extension_activated( 'YITH_Woocompare' );
	}
}


/**
 * Enables template debug mode
 */
function mweb_template_debug_mode() {
	if ( ! defined( 'MWEB_TEMPLATE_DEBUG_MODE' ) ) {
		$status_options = get_option( 'woocommerce_status_options', array() );
		if ( ! empty( $status_options['template_debug_mode'] ) && current_user_can( 'manage_options' ) ) {
			define( 'MWEB_TEMPLATE_DEBUG_MODE', true );
		} else {
			define( 'MWEB_TEMPLATE_DEBUG_MODE', false );
		}
	}
}

add_action( 'after_setup_theme', 'mweb_template_debug_mode', 20 );

/**
 * Get other templates (e.g. product attributes) passing attributes and including the file.
 *
 * @access public
 * @param string $template_name
 * @param array $args (default: array())
 * @param string $template_path (default: '')
 * @param string $default_path (default: '')
 * @return void
 */

function mweb_get_template( $template_name, $args = array(), $template_path = '', $default_path = '' ) {
	if ( $args && is_array( $args ) ) {
		extract( $args );
	}

	$located = mweb_locate_template( $template_name, $template_path, $default_path );

	if ( ! file_exists( $located ) ) {
		_doing_it_wrong( __FUNCTION__, sprintf( '<code>%s</code> does not exist.', $located ), '2.1' );
		return;
	}

	// Allow 3rd party plugin filter template file from their plugin
	$located = apply_filters( 'mweb_get_template', $located, $template_name, $args, $template_path, $default_path );

	do_action( 'mweb_before_template_part', $template_name, $template_path, $located, $args );

	include( $located );

	do_action( 'mweb_after_template_part', $template_name, $template_path, $located, $args );
}

/**
 * Locate a template and return the path for inclusion.
 *
 * This is the load order:
 *
 *		yourtheme		/	$template_path	/	$template_name
 *		yourtheme		/	$template_name
 *		$default_path	/	$template_name
 *
 * @access public
 * @param string $template_name
 * @param string $template_path (default: '')
 * @param string $default_path (default: '')
 * @return string
 */
function mweb_locate_template( $template_name, $template_path = '', $default_path = '' ) {
	if ( ! $template_path ) {
		$template_path = 'templates/';
	}

	if ( ! $default_path ) {
		$default_path = 'templates/';
	}

	// Look within passed path within the theme - this is priority
	$template = locate_template(
		array(
			trailingslashit( $template_path ) . $template_name,
			$template_name
		)
	);

	// Get default template
	if ( ! $template || MWEB_TEMPLATE_DEBUG_MODE ) {
		$template = $default_path . $template_name;
	}

	// Return what we found
	return apply_filters( 'mweb_locate_template', $template, $template_name, $template_path );
}








/**
 * WooCommerce_Legacy_Grant_Download_Permissions class.
 */
class WooCommerce_Legacy_Grant_Download_Permissions {

	/**
	 * Instance of this class.
	 *
	 * @var object
	 */
	protected static $instance = null;

	/**
	 * Initialize the plugin actions.
	 */
	private function __construct() {
		// Stop if WooCommerce isn't activated.
		if ( ! class_exists( 'WC_Admin_Post_Types', false ) ) {
			return;
		}

		// Remove WooCommerce 3.0 download permission action.
		remove_action( 'woocommerce_process_product_file_download_paths', array( 'WC_Admin_Post_Types', 'process_product_file_download_paths' ), 10, 3 );

		// Backwards compatibility method.
		add_action( 'woocommerce_process_product_file_download_paths', array( $this, 'grant_download_permissions' ), 10, 3 );
	}

	/**
	 * Return an instance of this class.
	 *
	 * @return object A single instance of this class.
	 */
	public static function get_instance() {
		// If the single instance hasn't been set, set it now.
		if ( null === self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}

	/**
	 * Grant download permissions like WooCommerce 2.6.
	 *
	 * This method performs a heavy query and should not be used for anyone!
	 *
	 * @param int  $product_id          Product identifier.
	 * @param int  $variation_id        Optional product variation identifier.
	 * @param array $downloadable_files Newly set files.
	 */
	public function grant_download_permissions( $product_id, $variation_id, $downloadable_files ) {
		global $wpdb;

		if ( $variation_id ) {
			$product_id = $variation_id;
		}

		if ( ! $product = wc_get_product( $product_id ) ) {
			return;
		}

		$existing_download_ids = array_keys( (array) $product->get_downloads() );
		$updated_download_ids  = array_keys( (array) $downloadable_files );
		$new_download_ids      = array_filter( array_diff( $updated_download_ids, $existing_download_ids ) );
		$removed_download_ids  = array_filter( array_diff( $existing_download_ids, $updated_download_ids ) );

		if ( ! empty( $new_download_ids ) || ! empty( $removed_download_ids ) ) {
			// Determine whether downloadable file access has been granted via the typical order completion, or via the admin ajax method.
			$existing_orders = $wpdb->get_col( $wpdb->prepare( "SELECT order_id from {$wpdb->prefix}woocommerce_downloadable_product_permissions WHERE product_id = %d GROUP BY order_id", $product_id ) );

			foreach ( $existing_orders as $existing_order_id ) {
				$order = wc_get_order( $existing_order_id );

				if ( $order ) {
					// Remove permissions.
					if ( ! empty( $removed_download_ids ) ) {
						foreach ( $removed_download_ids as $download_id ) {
							if ( apply_filters( 'woocommerce_process_product_file_download_paths_remove_access_to_old_file', true, $download_id, $product_id, $order ) ) {
								$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->prefix}woocommerce_downloadable_product_permissions WHERE order_id = %d AND product_id = %d AND download_id = %s", $order->get_id(), $product_id, $download_id ) );
							}
						}
					}

					// Add permissions.
					if ( ! empty( $new_download_ids ) ) {
						foreach ( $new_download_ids as $download_id ) {
							if ( apply_filters( 'woocommerce_process_product_file_download_paths_grant_access_to_new_file', true, $download_id, $product_id, $order ) ) {
								// Grant permission if it doesn't already exist.
								if ( ! $wpdb->get_var( $wpdb->prepare( "SELECT 1=1 FROM {$wpdb->prefix}woocommerce_downloadable_product_permissions WHERE order_id = %d AND product_id = %d AND download_id = %s", $order->get_id(), $product_id, $download_id ) ) ) {
									wc_downloadable_file_permission( $download_id, $product_id, $order );
								}
							}
						}
					}
				}
			}
		}
	}
}

add_action( 'admin_init', array( 'WooCommerce_Legacy_Grant_Download_Permissions', 'get_instance' ) );
