<?php
//frontend script
if ( ! function_exists( 'mweb_theme_register_frontend_script' ) ) {
	function mweb_theme_register_frontend_script() {
		
		$custom_file = mweb_theme_util::get_theme_option('mweb_custom_file_cssjs');
		$video_player = mweb_theme_util::get_theme_option('mweb_video_player');


		// Register scripts	
		wp_register_script('plugins-theme', THEME_ASSET . '/js/plugins-theme.js', array(),THEME_VERSION, true);
		wp_register_script('my-script', THEME_ASSET . '/js/my-script.js', array('plugins-theme'),THEME_VERSION, true);

		wp_enqueue_script("jquery");
		
		
		// Load the custom scripts
		wp_enqueue_script('plugins-theme');
		wp_enqueue_script("jquery-effects-core");
		wp_enqueue_script("wp-mediaelement");
		
		if( is_singular(array( 'product', 'lp_course', 'sfwd-courses' )) && $video_player == 'videojs'){
			//wp_enqueue_script('plyr', 'https://cdn.plyr.io/3.6.2/plyr.js', array(), '3.6.2');
			wp_enqueue_script('plyr', 'https://vjs.zencdn.net/7.8.4/video.js', array(), '7.8.4');
			//wp_enqueue_script('plyr-hls', 'https://cdnjs.cloudflare.com/ajax/libs/videojs-contrib-hls/5.15.0/videojs-contrib-hls.js', array(), '7.8.4');
			wp_enqueue_script('plyr-hls', THEME_ASSET . '/js/videojs-contrib-quality-levels.min.js', array(), '7.8.4');
			wp_enqueue_script('plyr-hls-q', THEME_ASSET . '/js/videojs-hls-quality-selector.min.js', array(), '7.8.4');
		}
		
		wp_enqueue_script('my-script');
	
	
		//load custom script
		if($custom_file){
			wp_enqueue_script( 'custom-script', get_template_directory_uri() . '/custom/custom.js', array('jquery','plugins-theme','my-script'), '1.0', true );
		}


		//load comment script
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}

		// Load the stylesheets
		wp_register_style( 'plugins-theme', THEME_ASSET . '/css/plugins-theme.css',array(),THEME_VERSION);
		wp_register_style( 'woocommerce', THEME_ASSET . '/css/woocommerce.css',array(),THEME_VERSION);


		if( is_singular(array( 'product', 'lp_course', 'sfwd-courses' )) && $video_player == 'videojs'){
			//wp_enqueue_style( 'plyr-css', 'https://cdn.plyr.io/3.6.2/plyr.css' , false ,'3.6.2' );
			wp_enqueue_style( 'plyr-css', 'https://vjs.zencdn.net/7.8.4/video-js.css' , false ,'7.8.4' );
		}

		wp_enqueue_style( 'mweb-style', get_stylesheet_uri() , array('plugins-theme' ,'woocommerce','wp-mediaelement'),THEME_VERSION );
		
		if($custom_file){
			wp_enqueue_style( 'custom-style', get_template_directory_uri() . '/custom/custom.css', array('plugins-theme','mweb-style'), '1.0', 'all' );
		}

		wp_dequeue_style( 'woo-wallet-style' );
		

	}

	if ( ! is_admin() ) {
		add_action( 'wp_enqueue_scripts', 'mweb_theme_register_frontend_script' );
	}
	
	
}




