<?php
/**
 * Class mweb_theme_featured
 */


/*-----------------------------------------------------------------------------------*/
/* Get comment posts
/*-----------------------------------------------------------------------------------*/

function mweb_layout_comments($comment, $args, $depth) {
    $tag = ( 'div' === $args['style'] ) ? 'div' : 'li';
    ?>
<<?php echo $tag; ?> id="comment-<?php comment_ID(); ?>" <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent', $comment ); ?>>
    <article id="div-comment-<?php comment_ID(); ?>" class="comment-body">
		<div class="comment-top">
			<div class="comment-meta">
				<?php echo get_avatar( $comment, 50 ); ?>
				<div class="comment-info">
					<cite class="comment-author"><span><?php echo get_comment_author_link(); ?></span></cite>
					<span><?php printf(__('%s', 'mahdisweb'), get_comment_date('j M Y')) ?></span>
				</div>
				<div class="action-link">
					<?php $reply_args = array_merge( $args, array('reply_text' => __('پاسخ', 'mahdisweb'), 'depth' => $depth, 'max_depth' => $args['max_depth'])); ?> 					
					<?php comment_reply_link($reply_args, $comment->comment_ID); ?>
				</div>
				<?php if( function_exists("get_post_ul_meta") ) : ?>
					<span class="comment-like" onclick="alter_ul_post_values(this,'<?php echo get_comment_ID(); ?>','c_like')"><i class="fa fa-plus-square"></i><span><?php echo get_post_ul_meta(get_comment_ID(),"c_like"); ?></span></span>
					<span class="comment-dislike" onclick="alter_ul_post_values(this,'<?php echo get_comment_ID(); ?>','c_dislike')"><i class="fa fa-minus-square"></i><span><?php echo get_post_ul_meta(get_comment_ID(),"c_dislike"); ?></span></span>
				<?php endif; ?>

			</div>
		</div>
		<div class="comment-content">
            <?php if ( '0' == $comment->comment_approved ) : ?>
                <p><em><?php _e('منتظر تایید مدیر است', 'mahdisweb'); ?></em></p>
            <?php else: ?>
                <?php comment_text(); ?>
            <?php endif; ?>
        </div>

    </article>

    <?php 
}





/*-----------------------------------------------------------------------------------*/
/* Get comment Course
/*-----------------------------------------------------------------------------------*/

function mweb_course_comments($comment, $args, $depth) {
    $tag = ( 'div' === $args['style'] ) ? 'div' : 'li';
	global $comment;
	$post_id = $comment->comment_post_ID;
	$user = learn_press_get_user( $comment->user_id );
    ?>
<<?php echo $tag; ?> id="comment-<?php comment_ID(); ?>" <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent', $comment ); ?>>
    <article id="div-comment-<?php comment_ID(); ?>" class="comment-body">
		<div class="comment-top">
			<div class="comment-meta">
				<?php echo get_avatar( $comment, 50 ); ?>
				<div class="comment-info">
					<cite class="comment-author"><span><?php echo get_comment_author_link(); ?></span><?php if($user->has_enrolled_course( $post_id )){	echo '<div class="bought_an_item"><i class="fal fa-user-check"></i>دانشجو</div>'; } ?></cite>
					<span><?php printf(__('%s', 'mahdisweb'), get_comment_date('j M Y')) ?></span>
				</div>
				<div class="action-link">
					<?php $reply_args = array_merge( $args, array('reply_text' => __('پاسخ', 'mahdisweb'), 'depth' => $depth, 'max_depth' => $args['max_depth'])); ?> 					
					<?php comment_reply_link($reply_args, $comment->comment_ID); ?>
				</div>
				<?php 
					$rate_v = get_comment_meta($comment->comment_ID, 'rating', true);
					if(!empty($rate_v))
						echo '<div class="lp_cm_rate cm_rate'.$rate_v.'">'.mweb_get_comment_rate_data($rate_v).'</div>'; 
				?>
			</div>
		</div>
		<div class="comment-content">
            <?php if ( '0' == $comment->comment_approved ) : ?>
                <p><em><?php _e('منتظر تایید مدیر است', 'mahdisweb'); ?></em></p>
            <?php else: ?>
                <?php comment_text(); ?>
            <?php endif; ?>
        </div>
    </article>

    <?php 
}










