<?php
/**-------------------------------------------------------------------------------------------------------------------------
 * ajax search
 */
if ( ! function_exists( 'mweb_theme_ajax_search' ) ) {
	add_action( 'wp_ajax_nopriv_mweb_theme_ajax_search', 'mweb_theme_ajax_search' );
	add_action( 'wp_ajax_mweb_theme_ajax_search', 'mweb_theme_ajax_search' );




	function mweb_theme_ajax_search() {

		$param_search = '';
		$str          = '';

		if ( ! empty( $_POST['s'] ) ) {
			$param_search = mweb_theme_data_validate( $_POST['s'] );
		}

		$param = array(
			's'           => $param_search,
			'post_type'   => array( 'post' ),
			'post_status' => 'publish',
		);
		
		$product_var = false;
		$mweb_search_filter = mweb_theme_util::get_theme_option( 'search_filter' );
		if ( $mweb_search_filter == true ) {
			$product_var = true;
		}


		$data_query = new WP_Query( $param );

		if ( $data_query->have_posts() ) {

			$counter = 1;

			while ( $data_query->have_posts() ) {
				$data_query->the_post();
				$str .= '<div class="post_with_thumb">';
					$str .= '<div class="post-thumb">'.get_the_post_thumbnail( get_the_ID(), 'mini_blog' ).'</div>'; 
					$str .= '<div class="inner"><a href="' . get_permalink() . '" title="' . get_the_title() . '">' . get_the_title() . '</a>';
					if($product_var){
						global $product;
						if ( $price_html = $product->get_price_html() ) : 
							$str .= '<span class="price">'.$price_html.'</span>';
						endif; 
					}
					$str .= '</div>';
				$str .= '</div>';

				if ( $counter > 5 ) {
					$str .= '<div class="header-search-more post-btn"><button type="submit">مشاهده همه نتایج</button></div>';
					break;
				}
				$counter ++;
			}
		} else {
			$str = '<div class="header-search-not-found"> نتیجه ای یافت نشد </div>';
		}
		wp_reset_postdata();

		die( json_encode( $str ) );
	}
}
