<?php
/**
 * Template Name: در دست ساخت
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="profile" href="http://gmpg.org/xfn/11">
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
        <?php wp_head(); ?>
    </head>
    <body <?php body_class(); ?>>
        <div class="under_construction">
		<div class="container">
		<div class="construction_head">
			<div class="logo" <?php mweb_theme_schema::makeup('logo'); ?>>
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/under_construction_machine.gif" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" 				            <?php mweb_theme_schema::makeup('image'); ?>>
			</div>
		</div>
		
		<?php 
		
			$under_construction_title = mweb_theme_util::get_theme_option( 'under_construction_title' );
			$under_construction_content = mweb_theme_util::get_theme_option( 'under_construction_content' );


			echo '<h2>'.$under_construction_title.'</h2>';
			if($under_construction_content){
				echo '<div class="construction_entry entry">'.$under_construction_content.'</div>';
			}
			$under_construction_time = mweb_theme_util::get_theme_option( 'under_construction_time' );
			if(!empty($under_construction_time)){
				printf('<div class="construction_countdown"><div class="product-date" data-date="%s"></div></div>',$under_construction_time);
			}

		?>
	

		</div>
        </div> <!-- under_construction -->
        <?php wp_footer(); ?>
    </body>
</html>