var mweb_instagram_popup;
var mweb_popup_pic;
var mweb_popup_day;
var mweb_popup_link;

(function($) {
    "use strict";

    var mweb_theme = {

        window: $(window),
        html: $('html, body'),
        document: $(document),
        body: $('body'),
        window_last_pos: 0,
        direction: '',
        ajax_filter_item_last_width: [],
        ajax: {},
        resize_timer: '',
        get_rtl: function() {
            return mweb_theme.body.hasClass('rtl');
        },

        document_ready: function() {
			mweb_theme.my_account_modal();
			mweb_theme.search_header();
			mweb_theme.canvas_menu_mobile();
			mweb_theme.go_to_top();
			mweb_theme.init_carousel();
			mweb_theme.init_swiper_slider();
			mweb_theme.init_count_down();
			mweb_theme.single_post_gallery();
			mweb_theme.init_multimedia();
			mweb_theme.redesign_variation_form();
			mweb_theme.instagram_popup_widget();
			mweb_theme.mweb_sticky_cart_box();
			mweb_theme.mweb_nav_to_select();
			mweb_theme.mweb_sticky_header();
			mweb_theme.mweb_init_rating();
			mweb_theme.mweb_init_quantity();
			mweb_theme.mweb_curriculum();
			mweb_theme.initslider_realtime();
			
			$('.product-categories').mwAccordion({
				btn_open: '<span class="ac-tongle open"></span>',
				btn_close: '<span class="ac-tongle close"></span>',
			});
			
			$.extend(true, $.magnificPopup.defaults, {
				tClose: 'بستن', 
				tLoading: 'بارگذاری ...', 
				gallery: {
					tPrev: 'قبل', 
					tNext: 'بعد', 
					tCounter: '%curr% از %total%' 
				},
				image: {
					tError: '<a href="%url%">عکس</a> نمی تواند بارگذاری شود.' 
				},
				ajax: {
					tError: '<a href="%url%">محتوا</a> نمی تواند بارگذاری شود.' 
				}
			});
			
			if ( $('.accordion-shortcode').length > 0 ){
				$(".accordion-shortcode").smoothAccordion();
			}
			
			$('.progress .progress-bar').progressbar();
			$('.recommended_warp select').niceSelect();
			
			$("body *[data-toggle='tooltip']").each(function(){
				$(this).tooltip();
			});
			
			$('.yith-wcwl-add-button .add_to_wishlist, .yith-wcwl-wishlistaddedbrowse a, .yith-wcwl-wishlistexistsbrowse a').each(function(){
				$(this).attr('data-toggle', 'tooltip').attr('data-original-title', $(this).text().trim());
			});
			
			$('.or_view').click(function(e) {
				e.preventDefault();
				$(this).parents('.morder_item').next().slideToggle();
			});
			
			$('.notify_item .el_more').click(function(e) {
				e.preventDefault();
				$(this).parents('.meta_notify').next().slideToggle();
			});
			
			$('.close_alert').click(function(e){
				e.preventDefault();
				$('.header_alert').hide('fast');
				mweb_theme.createCookie('haed_alert',true,1);
			});
			
			$('.term-description-wrap .loadmore').click(function(e){
				e.preventDefault(); 
				$('.term-description').toggleClass('desc_show', function() {
				  if ( $( this ).is( ".desc_show" ) ) {
					$('.loadmore').text('کمینه کردن اطلاعات ...');
				  } else {
					$('.loadmore').text('اطلاعات بیشتر ...');
				  }
				});
			});
			

			$('.fixed_elm_btn').click(function(e){
				e.preventDefault();
				$(this).toggleClass('is_active');
				$('body').toggleClass('nav-active');
			});
			
			$('.course_item.has_desc').each(function() {
				$(this).off('click').on('click', function(e) {
					e.preventDefault();
					$(this).toggleClass('i_active').next('.course_item_content').slideToggle();
				});
			});
				
			 
        },

        document_load: function() {
            mweb_theme.window.load(function() {
                mweb_theme.body.addClass('mweb-js-loaded');
				if(mweb_popup_pic){
					mweb_theme.mweb_popup_init(mweb_popup_pic,mweb_popup_link);
					mweb_theme.createCookie('run_popup',true,mweb_popup_day);
				}
				if(!mweb_theme.readCookie('haed_alert')){
					$('.header_alert').show();
				}
            });
        },

        document_reload: function() {
			$("body *[data-toggle='tooltip']").each(function(){
				$(this).tooltip();
			});
			
			$('.yith-wcwl-add-button .add_to_wishlist, .yith-wcwl-wishlistaddedbrowse a, .yith-wcwl-wishlistexistsbrowse a').each(function(){
				$(this).attr('data-toggle', 'tooltip').attr('data-original-title', $(this).text().trim());
			});
        },

        document_resize: function() {
            mweb_theme.window.resize(function() {

              
            })
        },
		
		
		
		initslider_realtime: function () {
			$(".owl-realtime").owlCarousel({
				items: 1,
				loop: true,
				rtl:true ,
				autoplay: true,
				dots: false,
				onInitialized: mweb_theme.startProgressBar,
				onTranslate: mweb_theme.resetProgressBar,
				onTranslated: mweb_theme.startProgressBar
			});
		},

		startProgressBar: function () {
			$(".slide-progress").css({
				width: "100%",
				transition: "width 5000ms"
			});
		},

		resetProgressBar: function () {
			$(".slide-progress").css({
				width: 0,
				transition: "width 0s"
			});
		},
		
		
		my_account_modal: function() {
			var acc_form = $('.account_action');
			var mask_overlay = $('.mweb-site-mask');
			$('span.login_user_btn').on('click',function(){
				mask_overlay.addClass('active');
				acc_form.addClass('active');
				acc_form.find('.acc_div').hide();
				$('.login_form').show();
			});
			$('span.singup_user_btn').on('click',function(){
				mask_overlay.addClass('active');
				acc_form.addClass('active');
				acc_form.find('.acc_div').hide();
				$('.register_form').show();
			});
			
			$('.mweb-site-mask , .close_modal').on('click',function(){
				acc_form.removeClass('active');
				mask_overlay.removeClass('active');
			});
        },
		
		
		search_header: function() {
			$('.m_search').on('click',function(e){
				e.preventDefault();
				$('.search_wrap').toggleClass('active');
				if($('.search_wrap').hasClass('active')){
					$(this).find('i').removeClass('fa-search').addClass('fa-times');
				}else{
					$(this).find('i').removeClass('fa-times').addClass('fa-search');
				}
			});
			
        },
		
		
		canvas_menu_mobile: function() {
			var mweb_off_canvas_button = $('#mweb-trigger');
			var mweb_off_canvas_button_close = $('#mweb-close-off-canvas');
			var mweb_mask = $('.mweb-site-mask');

			mweb_off_canvas_button.click(function() {
				mweb_theme.body.toggleClass('mobile-js-menu');
				return false;
			});

			mweb_off_canvas_button_close.click(function() {
				mweb_theme.body.removeClass('mobile-js-menu');
				return false;
			});

			mweb_mask.click(function() {
				mweb_theme.body.removeClass('mobile-js-menu');
				return false;
			});


			var mobile_menu = $('.mobile-menu-wrap');
			var sub_mobile_menu = mobile_menu.find('li.menu-item-has-children');
			var sub_mobile_a = mobile_menu.find('li.menu-item-has-children > a');

			sub_mobile_a.append('<i class="explain-menu fal fa-angle-left"></i>');

			$('.explain-menu').off('click').on('touchend click', function(e) {
				e.preventDefault();
				$(this).parent('a').toggleClass('active').siblings('ul').slideToggle(500);
			});

			sub_mobile_menu.find('a').click(function(event) {
				event.stopPropagation();
			});

			mobile_menu.click(function(event) {
				event.stopPropagation();
			});
			
        },
		
		
		go_to_top: function() {
			$('.gototop').click(function(){
				$('html,body').animate({scrollTop:0},'slow');return false;
			});	
        },
		
		
		init_carousel: function() {
			$('.mw-owl-carousel').each(function() {
				var config = $(this).data();
				config.navText = ['<i class="fal fa-angle-left"></i>', '<i class="fal fa-angle-right"></i>'];
				var animateOut = $(this).data('animateout');
				var animateIn = $(this).data('animatein');

				if (typeof animateOut != 'undefined') {
					config.animateOut = animateOut;
				}
				if (typeof animateIn != 'undefined') {
					config.animateIn = animateIn;
				}
				
				var owl = $(this);
				owl.owlCarousel(config);
				$(this).find('.owl-item').removeClass('last-item');
				$(this).find('.owl-item.active').last().addClass('last-item');

				var t = $(this);
				owl.on('changed.owl.carousel', function(event) {
					var item = event.item.index;
					t.find('.owl-item').removeClass('last-item');
					setTimeout(function() {
						t.find('.owl-item.active').last().addClass('last-item');
					}, 100);

				});
				if (config.nav == true) {
					var k = $(this);
					var ts = k.parents('.mweb-block-wrap').find('.block-title');
					//var ts = k.prev('.block-title');

					if (ts.length) {
						ts.append('<div class="owl-nav"><div class="owl-prev"><i class="fal fa-angle-left"></i></div><div class="owl-next"><i class="fal fa-angle-right"></i></div></div>');
						var owlurun = $(this);
						// owlurun.owlCarousel();
						ts.find('.owl-prev').click(function() {
							owlurun.trigger('next.owl.carousel');
						});
						ts.find('.owl-next').click(function() {
							owlurun.trigger('prev.owl.carousel');
						});
					}
				}
				
				config = undefined;

			});
		},
		
		
		init_count_down: function(){
			if($('.product-date').length > 0){
				$('.product-date').each(function(i,item){
				  var date = $(item).attr('data-date');
				  $(item).countdown(date).on('update.countdown', function(event) {
					  var $this = $(this).html(event.strftime(''
						+ '<div class="day"><span class="no">%D</span><span class="text">روز</span></div>'
						+ '<div class="hours"><span class="no">%H</span><span class="text">ساعت</span></div>'
						+ '<div class="min"><span class="no">%M</span><span class="text">دقیقه</span></div>'
						+ '<div class="second"><span class="no">%S</span><span class="text">ثانیه</span></div>'));
					}).on('finish.countdown', function(event) {
					  $(this).html('تمام شد').parent().addClass('disabled');

					});
					
				});
			} 
		},
		
		
		init_swiper_slider: function() {
			$('.mweb-swiper').each(function() {
				var swiper_c = $(this).find('.swiper-container');
				if(swiper_c.length > 0){
					var configs = swiper_c.data('slider');
					var myswiper = new Swiper(swiper_c, configs );
					//console.log(configs);
					configs = undefined;
				}
			});
		
		},
		
		single_post_gallery: function() {
			if($('#post_format_gallery').length >0){
				$("#post_format_gallery").justifiedGallery({
					rowHeight : 140,
					captions: false,
					lastRow: "justify",
					margins : 5
				});
				$("#post_format_gallery").magnificPopup({
					delegate: "a",
					type: "image",
					zoom: {
						enabled: true,
						duration: 500, // duration of the effect, in milliseconds
						easing: 'ease', // CSS transition easing function
						opener: function (element) {
							return element.find('img');
						}
					},
					gallery: {
						enabled: true,
						navigateByImgClick: true,
						preload: [0, 1]
					}
				});
			}
		},
		
		init_multimedia: function() {
		    $('video:not(#preview_product):not(.vjs-tech):not(.elementor-background-video-hosted)').mediaelementplayer ({
				startLanguage:'fa',
				translations:['fa'],
				alwaysShowControls: true,
				videoVolume: 'horizontal',
				features: ['playpause','loop','current','progress','duration','tracks','volume', 'fullscreen'],

			});
			$('audio').mediaelementplayer ({
				startLanguage:'fa',
				translations:['fa'],
				videoVolume: 'horizontal',
				features: ['playpause','loop','current','progress','duration','volume'],

			});
			
			if( $('.product_thumbnail').length > 0 ){
				
				if($('.product_thumbnail').hasClass('player_is_mediaelement')){ 
				
					var player = $('#preview_product');
					player.mediaelementplayer ({
						startLanguage:'fa',
						translations:['fa'],
						videoVolume: 'horizontal',
						features: ['playpause','loop','current','progress','duration','tracks','volume', 'fullscreen'],
					}); 
					
					$('.free_play').on('click', function(e){
						e.preventDefault();
						e.stopPropagation();
						$('.course_item').removeClass('is_active');
						$(this).closest('.course_item').addClass('is_active');
						var media_src = $(this).closest('.course_item').data('preview');
						if (!player[0].paused) {
							player[0].pause();
						}
						player[0].setSrc(media_src);
						player[0].play();
						$('html, body').animate({
							scrollTop: ($('.product_thumbnail').offset().top)
						},500);
					});
					
				}else{
					
					if($('#preview_product').length > 0){
						var player = videojs('preview_product', {
							controls: true,
							autoplay: false,
							preload: 'auto',
							fluid: true,
							responsive: true,
							playbackRates: [0.7, 1.0, 1.5, 2.0]
						});
						
						player.hlsQualitySelector({
							displayCurrentQuality: true,
						});
						
						$('.free_play').on('click', function(e){
							e.preventDefault();
							e.stopPropagation();
							$('.course_item').removeClass('is_active');
							$(this).closest('.course_item').addClass('is_active');
							var media_src = $(this).closest('.course_item').data('preview');
							if (!player.paused) {
								player.pause();
							}
							player.src(media_src);
							player.play();
							$('html, body').animate({
								scrollTop: ($('.product_thumbnail').offset().top)
							},500);
						});
					}
				
				}
			
			}
			
		},
		
		instagram_popup_widget: function () {
			if (1 == mweb_instagram_popup) {
				$('.instagram-el').find('a').magnificPopup({
					type: 'image',
					closeOnContentClick: true,
					closeBtnInside: true,
					removalDelay: 500,
					mainClass: 'mfp-fade',
					zoom: {
						enabled: true,
						duration: 500, // duration of the effect, in milliseconds
						easing: 'ease', // CSS transition easing function
						opener: function (element) {
							return element.find('img');
						}
					},
					gallery: {
						enabled: true,
						navigateByImgClick: true,
						preload: [0, 1]
					}
				});
			}
		},
		
		redesign_variation_form: function( $wrap ) {
        	if ( typeof $wrap == 'undefined') var $wrap = '';
        	if ( $wrap != '' ) {
	    		$wrap = $wrap+' .type-product.product-type-variable';
	    	}else{
	    		$wrap = '.type-product.product-type-variable';
	    	}
			if ( $($wrap).length  && typeof mw_arr_attr !== 'undefined' ) { 
				$($wrap).find('.variations select').each(function(){
					var select = $(this), select_div, var_attr = mw_arr_attr[select.attr('name')];
					if ( typeof var_attr == 'undefined') { return false; } 
					
					if (var_attr.type == 'select') { 
						$(this).niceSelect();
						return false;
					} 
					select_div = $('<div />', {
				                	'class': 'sellect-wrap'
				            	}).insertAfter(select);
					select.hide();

					select.find( 'option' ).each(function (){
						var option_old = $(this), option;
						if ( option_old.attr('value')!='' ) {
							var inner_opt, class_sellect, val_opt = var_attr.key_val[option_old.attr('value')];
							if (var_attr.type == 'color') {
								inner_opt = $('<span/>', {
												'html': option_old.text()
											});
								var outer_opt = $('<i/>', {
												'style':'background:' + val_opt,
											}).appendTo(inner_opt);
								class_sellect = ' color';
							}else if (var_attr.type == 'image') {
								inner_opt = $('<span/>', {
												'style':'background-image:url("' + val_opt + '")'
											});
								class_sellect = ' image';
							}else if (var_attr.type == 'text') {
								inner_opt = $('<span/>', {
												'html': val_opt
											});
								class_sellect = ' text';
							}
							
							if (var_attr.type != 'select') { 
								option = $('<div/>', {
											'class': 'option'+class_sellect,
											'data-toggle':'tooltip',
											'data-original-title':option_old.text(),
											'data-value': option_old.attr('value')
										}).appendTo(select_div);
								inner_opt.appendTo(option);
								if ( option_old.val() == select.val() ){
									option.addClass('selected');
								}
								
								option.on('click', function () {
									// Update variation values
									if ( $(this).hasClass('selected') ) {
										select.val('').change();
									} else {
										select.val( option_old.val() ).change();
									}
									mweb_theme.set_selected_opt( $(this) );
								});
							}
						}
					});
					
				});
				$( document ).on( 'click', '.variations_form .reset_variations', function(event) {
					$('.variations_form .sellect-wrap .option').removeClass('selected');
				});
			}
		},
		
		
		set_selected_opt: function( option ) {
	        option.toggleClass('selected');
	        option.siblings().removeClass('selected');
	    },
		
		mweb_popup_init: function( $photo , $link ) {
						
			if(!mweb_theme.readCookie('run_popup')){
				
				$.magnificPopup.open({
				 
				  mainClass: 'mweb-popup',
				  tLoading: '',
				  tClose: 'دیگر نمایش نده',
				  items: { src: $('<div class="white-popup"><a href="'+$link+'"><img src="'+$photo+'" /></a></div>') },
				  type: 'inline'
				}, 0);
				
			}
		},
		
		
		mweb_sticky_cart_box: function() {
						
			if(mweb_theme.body.hasClass('single-product') && $('.entry-summary').length > 0){
			
				var add_tocart_top = $('.single_title_product').offset().top + $('.single_title_product').height();
				var add_tc = $('.vr_desktop');
				var add_tc_m = $('.vr_mobile');
				var content_el = $('#content').height() - $('.main_footer').height();
				$(window).scroll(function(event){
					var scl_top = $(this).scrollTop();
					if (scl_top > add_tocart_top && scl_top < content_el) { 
						add_tc.addClass('fixed');
					}else {
						add_tc.removeClass('fixed'); 
					}
					if (scl_top > add_tocart_top) { 
						add_tc_m.addClass('fixed');
					}else {
						add_tc_m.removeClass('fixed'); 
					}
				});
			
			}
		},
		
		mweb_sticky_header: function() {
						
			if($(".menu_sticky").length > 0){
			
				var offset_top = $('header').height();
				$(window).scroll(function(event){
					var currentScroll = $(this).scrollTop();
					if (currentScroll > offset_top ){
						$('.menu_sticky').addClass('my_sticky');
					} else {
						$('.menu_sticky').removeClass('my_sticky');
					}
				});
			
			}
		},
		
		mweb_init_rating: function() {
			
			$('.course_rating i').on('click',function(e){
				//e.preventDefault();
				$('.course_rating i').removeClass('active');
				var inx = $(this).attr("data-value");
				$(this).addClass('active');
				var el_select = $(this).parent().prev();
				el_select.val(inx);
			});			
			
		},
		
		mweb_init_quantity: function(){
			$(document).on('click', '.increase', function(e) {
				e.preventDefault(); 
				var currentVal = parseInt($(this).parents('.quantity').find('input.qty').val()); 
				var maxVal = parseInt($(this).parents('.quantity').find('input.qty').attr("max"));
				if(isNaN(maxVal)){ maxVal = 100; }
				if (!isNaN(currentVal) && currentVal < maxVal) {
				  $(this).parents('.quantity').find('input.qty').val(currentVal + 1).change();
				}
			});
			$(document).on('click', '.reduced', function(e) {
				e.preventDefault();
				var currentVal = parseInt($(this).parents('.quantity').find('input.qty').val());
				if (!isNaN(currentVal) && currentVal > 1) {
				  $(this).parents('.quantity').find('input.qty').val(currentVal - 1).change();
				}
			});
		},
		
		mweb_curriculum: function(){
			$('.product_acc_title').click( function(e) {
				e.preventDefault(); 
				if($(this).hasClass('active')){
					$(this).removeClass('active');
					$(this).next().slideUp('slow');
				}else{
					$(this).addClass('active');
					$(this).next().slideDown('slow');
				}
				
			});
			
		},
		
		mweb_nav_to_select: function() {
			var el_area = $(".top_menu");
			if(el_area.find('ul').length > 0){
				var el_select = $("<select />");

				$("<option />", {
					"selected": "selected",
					"value"   : "",
					"text"    : "انتخاب فهرست"
				}).appendTo(el_select);

				$('.top_menu a').each(function() {
					var el = $(this);
					$("<option />", {
						"value"   : el.attr("href"),
						"text"    : el.text()
					}).appendTo(el_select);
				});
				
				el_area.append(el_select);
				
				$(el_select).change(function() {
					window.location = $(this).find("option:selected").val();
				});	
			}				
		},
		
		createCookie: function ($name,$value,$days) {
			if ($days) {
				var date = new Date();
				date.setTime(date.getTime()+($days*24*60*60*1000));
				var expires = "; expires="+date.toGMTString();
			}
		   else var expires = "";
		   document.cookie = $name+"="+$value+expires+"; path=/";
		},

		readCookie: function($name) {
			var nameEQ = $name + "=";
			var ca = document.cookie.split(';');
			for(var i=0;i < ca.length;i++) {
				var c = ca[i];
				while (c.charAt(0)==' ') c = c.substring(1,c.length);
			   if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);

			}
			return null;
		}

  
	};


    $(document).ready(function() {
        mweb_theme.document_ready();
        mweb_theme.document_load();
        mweb_theme.document_reload();
        mweb_theme.document_resize();
		
    });

})(jQuery);