<?php

namespace Never5\DownloadMonitor\Shop\Checkout\PaymentGateway\PayPal\Core;

use Never5\DownloadMonitor\Dependencies\PayPalHttp\Environment;

abstract class PayPalEnvironment implements Environment
{
    private $clientId;
    private $clientSecret;

    public function __construct($clientId, $clientSecret)
    {
        $this->clientId = $clientId;
        $this->clientSecret = $clientSecret;
    }

    public function authorizationString()
    {
        return base64_encode($this->clientId . ":" . $this->clientSecret);
    }
}

